/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import ham_fisted.IMutList;
import ham_fisted.Reducible;
import java.util.Collection;
import java.util.List;
import java.util.function.LongConsumer;

public class IndexConsumer
implements LongConsumer,
Reducible,
IDeref {
    final IFn rangeFn;
    final IMutList list;
    long firstVal;
    long lastVal;
    long increment;
    long minVal;
    long maxVal;

    public IndexConsumer(IFn iFn, IMutList iMutList) {
        this.rangeFn = iFn;
        this.list = iMutList;
        this.firstVal = Long.MIN_VALUE;
        this.lastVal = Long.MIN_VALUE;
        this.increment = Long.MIN_VALUE;
        this.minVal = Long.MAX_VALUE;
        this.maxVal = Long.MIN_VALUE;
    }

    public IndexConsumer(IFn iFn, IMutList iMutList, long l, long l2, long l3, long l4, long l5) {
        this.rangeFn = iFn;
        this.list = iMutList;
        this.firstVal = l;
        this.lastVal = l2;
        this.increment = l3;
        this.minVal = l4;
        this.maxVal = l5;
    }

    public String toString() {
        if (this.list.isEmpty()) {
            return new PersistentArrayMap(new Object[]{Keyword.intern((String)"firstVal"), this.firstVal, Keyword.intern((String)"lastVal"), this.lastVal, Keyword.intern((String)"increment"), this.increment, Keyword.intern((String)"min"), this.minVal, Keyword.intern((String)"max"), this.maxVal}).toString();
        }
        return this.list.toString();
    }

    void addToList(IMutList iMutList) {
        if (this.increment == Long.MIN_VALUE) {
            if (this.firstVal != Long.MIN_VALUE) {
                iMutList.addLong(this.firstVal);
            }
        } else if (this.increment == Long.MAX_VALUE) {
            iMutList.addAll((Collection)this.list);
        } else {
            iMutList.addAll((Collection)((List)this.rangeFn.invoke((Object)this.firstVal, (Object)(this.lastVal + this.increment), (Object)this.increment)));
        }
    }

    @Override
    public void accept(long l) {
        if (this.firstVal == Long.MIN_VALUE) {
            this.firstVal = l;
        } else {
            long l2 = l - this.lastVal;
            long l3 = this.increment;
            if (l3 == Long.MAX_VALUE) {
                this.list.addLong(l);
            } else if (l3 != l2) {
                if (l2 != 0L && l3 == Long.MIN_VALUE) {
                    this.increment = l2;
                } else {
                    this.addToList(this.list);
                    this.increment = Long.MAX_VALUE;
                    this.list.addLong(l);
                }
            }
        }
        this.lastVal = l;
        this.minVal = Math.min(l, this.minVal);
        this.maxVal = Math.max(l, this.maxVal);
    }

    public IndexConsumer reduce(Reducible reducible) {
        IndexConsumer indexConsumer = (IndexConsumer)reducible;
        if (this.firstVal == Long.MIN_VALUE) {
            return indexConsumer;
        }
        if (indexConsumer.firstVal == Long.MIN_VALUE) {
            return this;
        }
        long l = Math.min(this.minVal, indexConsumer.minVal);
        long l2 = Math.max(this.maxVal, indexConsumer.maxVal);
        if (this.increment != Long.MAX_VALUE && this.increment == indexConsumer.increment && this.lastVal + this.increment == indexConsumer.firstVal) {
            return new IndexConsumer(this.rangeFn, this.list, this.firstVal, indexConsumer.lastVal, this.increment, l, l2);
        }
        if (this.increment != Long.MAX_VALUE) {
            this.addToList(this.list);
        }
        indexConsumer.addToList(this.list);
        return new IndexConsumer(this.rangeFn, this.list, this.firstVal, (Long)this.list.invoke((Object)-1), Long.MAX_VALUE, l, l2);
    }

    public Object deref() {
        Object object = this.firstVal == Long.MIN_VALUE ? (IObj)this.rangeFn.invoke((Object)0) : (this.increment == Long.MAX_VALUE ? this.list : (IObj)this.rangeFn.invoke((Object)this.firstVal, (Object)(this.lastVal + this.increment), (Object)this.increment));
        return object.withMeta((IPersistentMap)new PersistentArrayMap(new Object[]{Keyword.intern((String)"min"), this.minVal, Keyword.intern((String)"max"), this.maxVal}));
    }
}

