/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.RT;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.IFnDef;
import ham_fisted.Reductions;
import ham_fisted.Transformables;
import java.util.List;
import tech.v3.datatype.Buffer;

public interface LongBuffer
extends Buffer {
    @Override
    default public Object elemwiseDatatype() {
        return Keyword.intern(null, (String)"int64");
    }

    default public boolean add(Object object) {
        this.addLong(Casts.longCast((Object)object));
        return true;
    }

    @Override
    default public double readDouble(long l) {
        return this.readLong(l);
    }

    @Override
    default public Object readObject(long l) {
        return this.readLong(l);
    }

    @Override
    default public void writeDouble(long l, double d) {
        this.writeLong(l, Casts.longCast((double)d));
    }

    @Override
    default public void writeObject(long l, Object object) {
        this.writeLong(l, Casts.longCast((Object)object));
    }

    @Override
    default public Buffer subBuffer(long l, long l2) {
        ChunkedList.sublistCheck((long)l, (long)l2, (long)this.lsize());
        if (l == 0L && l2 == this.lsize()) {
            return this;
        }
        return new LongSubBuffer(this, l, l2);
    }

    @Override
    default public void fillRange(final long l, List list) {
        if (list.isEmpty()) {
            return;
        }
        ChunkedList.checkIndexRange((long)0L, (long)this.lsize(), (long)l, (long)(l + (long)list.size()));
        Reductions.serialReduction((IFn)new Reductions.IndexedLongAccum((IFn.OLLO)new IFnDef.OLLO(){
            final /* synthetic */ LongBuffer this$0;
            {
                this.this$0 = longBuffer;
            }

            public Object invokePrim(Object object, long l3, long l2) {
                ((Buffer)object).writeLong(l3 + l, l2);
                return object;
            }
        }), (Object)this, (Object)list);
    }

    @Override
    default public Object reduce(IFn iFn, Object object) {
        IFn.OLO oLO = Transformables.toLongReductionFn((Object)iFn);
        long l = this.lsize();
        for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
            object = oLO.invokePrim(object, this.readLong(i));
        }
        return Reductions.unreduce((Object)object);
    }

    public static class LongSubBuffer
    extends Buffer.SubBuffer
    implements LongBuffer {
        public LongSubBuffer(LongBuffer longBuffer, long l, long l2) {
            super(longBuffer, l, l2);
        }

        @Override
        public void fillRange(long l, List list) {
            LongBuffer.super.fillRange(l + this.sidx, list);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return LongBuffer.super.reduce(iFn, object);
        }
    }
}

