/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import tech.v3.datatype.UnsafeUtil;
import xerial.larray.impl.LArrayNative;
import xerial.larray.impl.OSInfo;
import xerial.larray.mmap.MMapMode;

public class MMapBuffer {
    private final RandomAccessFile raf;
    private final FileChannel fc;
    private final long fd;
    private final int pagePosition;
    public final long address;
    public final long mapSize;

    public MMapBuffer(File file, MMapMode mMapMode) throws IOException {
        this(file, 0L, file.length(), mMapMode);
    }

    public MMapBuffer(File file, long l, long l2, MMapMode mMapMode) throws IOException {
        this.raf = new RandomAccessFile(file, mMapMode.mode);
        this.fc = this.raf.getChannel();
        FileDescriptor fileDescriptor = this.raf.getFD();
        try {
            Field field;
            if (!OSInfo.isWindows()) {
                field = fileDescriptor.getClass().getDeclaredField("fd");
                field.setAccessible(true);
                this.fd = field.getInt(fileDescriptor);
            } else {
                field = fileDescriptor.getClass().getDeclaredField("handle");
                field.setAccessible(true);
                this.fd = field.getLong(fileDescriptor);
            }
        }
        catch (Exception exception) {
            throw new IOException("Failed to retrieve file descriptor of " + file.getPath() + ": " + exception.getMessage());
        }
        long l3 = UnsafeUtil.unsafe.pageSize();
        this.pagePosition = (int)(l % l3);
        if (!this.fc.isOpen()) {
            throw new IOException("closed " + file.getPath());
        }
        long l4 = this.fc.size();
        if (l4 < l + l2) {
            this.raf.seek(l + l2 - 1L);
            this.raf.write(0);
        }
        long l5 = l - (long)this.pagePosition;
        this.mapSize = l2 + (long)this.pagePosition;
        long l6 = LArrayNative.mmap((long)this.fd, (int)mMapMode.code, (long)l5, (long)this.mapSize);
        this.address = l6 + (long)this.pagePosition;
    }

    public void close() throws IOException {
        this.fc.close();
    }

    protected long offset() {
        return this.pagePosition;
    }
}

