(ns tech.v3.datatype.datetime
  ;;Autogenerated from tech.v3.datatype.datetime-api-- DO NOT EDIT
  "Thorough bindings to java.time.datetime.  Includes packed datatypes and
lifting various datetime datatypes into the datatype system.


A general outline is:

  * There are a set of type-hinted constants you can use in your code however you like.
      - milliseconds-in-day, nanoseconds-in-second, etc.

  * There are type-hinted constructors for the types and ways to take a type and convert it to another type.
     - local-date, instant, zoned-date-time, etc.
     - local-date->instant, instant->zoned-date-time, etc.


  * There are a few generalized functions to create new datetime types or to convert a datetime type
    into milliseconds-since-epoch and back and to add/subtract integer amounts of different chronographic
    units:
     - datetime->milliseconds, milliseconds->datetime
     - plus-temporal-amount, minus-temporal-amount, long-temporal-amount
     - between"
  (:require [tech.v3.datatype.datetime-api]
            [tech.v3.datatype.datetime.base]
            [tech.v3.datatype.datetime.constants]
            [tech.v3.datatype.datetime.operations]))

(defn between
  "Find the time unit between two datetime objects.  Must have the same datatype.
  Units may be a chronounit or one of `#{:milliseconds :seconds :minutes :hours :days
  :weeks :months :years}` Returns longs or long readers.  Note that support for the
  various units across java.time the datatypes is partial."
  ([lhs rhs units]
  (tech.v3.datatype.datetime.operations/between lhs rhs units)))


(defn datetime->epoch
  "Convert datetime data to one of the epoch timestamps.  If timezone is passed in it is used
  else UTC is used.


  * `timezone` a java.time.ZoneId or nil.
  * `epoch-datatype` - one of `#{:epoch-microseconds :epoch-milliseconds :epoch-seconds :epoch-days}`
  * `data` - datetime scalar or vector data."
  ([timezone epoch-datatype data]
  (tech.v3.datatype.datetime.operations/datetime->epoch timezone epoch-datatype data))
  ([epoch-datatype data]
  (tech.v3.datatype.datetime.operations/datetime->epoch epoch-datatype data))
  ([data]
  (tech.v3.datatype.datetime.operations/datetime->epoch data)))


(defn datetime->milliseconds
  "Vectorized conversion of a datetime datatype to milliseconds with a given timezone (or utc timezone)
  and an implied 0 time offset."
  ([timezone data]
  (tech.v3.datatype.datetime.operations/datetime->milliseconds timezone data))
  ([data]
  (tech.v3.datatype.datetime.operations/datetime->milliseconds data)))


(defn datetime-datatype?
  ([datatype]
  (tech.v3.datatype.datetime.operations/datetime-datatype? datatype)))


(defn days-since-epoch->local-date
  (^{:tag java.time.LocalDate} [days zone-id]
  (tech.v3.datatype.datetime.base/days-since-epoch->local-date days zone-id))
  (^{:tag java.time.LocalDate} [days]
  (tech.v3.datatype.datetime.base/days-since-epoch->local-date days)))


(defn duration
  ([]
  (tech.v3.datatype.datetime.base/duration ))
  ([arg]
  (tech.v3.datatype.datetime.base/duration arg)))


(defn duration->milliseconds
  (^{:tag long} [duration]
  (tech.v3.datatype.datetime.base/duration->milliseconds duration)))


(defn duration->nanoseconds
  (^{:tag long} [duration]
  (tech.v3.datatype.datetime.base/duration->nanoseconds duration)))


(defn duration-datatype?
  ([dtype]
  (tech.v3.datatype.datetime.operations/duration-datatype? dtype)))


(defn epoch->datetime
  "Convert data in long or integer epoch data to a datetime datatype.

  * `timezone` - `java.time.ZoneId` or nil.
  * `epoch-datatype` - one of `#{:epoch-microseconds :epoch-milliseconds :epoch-seconds :epoch-days}`.
    In the case where it is not provided the elemwise-datatype of data must one of that set.
  * `datetime-datatype` - The target datatype.
  * `data` - data in integer or long format."
  ([timezone epoch-datatype datetime-datatype data]
  (tech.v3.datatype.datetime.operations/epoch->datetime timezone epoch-datatype datetime-datatype data))
  ([timezone datetime-datatype data]
  (tech.v3.datatype.datetime.operations/epoch->datetime timezone datetime-datatype data))
  ([datetime-datatype data]
  (tech.v3.datatype.datetime.operations/epoch->datetime datetime-datatype data)))


(defn epoch-days->epoch-months
  (^{:tag long} [ed]
  (tech.v3.datatype.datetime.base/epoch-days->epoch-months ed)))


(defn epoch-months->epoch-days
  (^{:tag long} [em]
  (tech.v3.datatype.datetime.base/epoch-months->epoch-days em)))


(defn epoch-months->local-date
  (^{:tag java.time.LocalDate} [em]
  (tech.v3.datatype.datetime.base/epoch-months->local-date em)))


(defn instant
  (^{:tag java.time.Instant} []
  (tech.v3.datatype.datetime.base/instant ))
  (^{:tag java.time.Instant} [arg]
  (tech.v3.datatype.datetime.base/instant arg)))


(defn instant->local-date-time
  (^{:tag java.time.LocalDateTime} [inst zone-id]
  (tech.v3.datatype.datetime.base/instant->local-date-time inst zone-id))
  (^{:tag java.time.LocalDateTime} [inst]
  (tech.v3.datatype.datetime.base/instant->local-date-time inst)))


(defn instant->microseconds-since-epoch
  (^{:tag long} [instant]
  (tech.v3.datatype.datetime.base/instant->microseconds-since-epoch instant)))


(defn instant->milliseconds-since-epoch
  (^{:tag long} [instant]
  (tech.v3.datatype.datetime.base/instant->milliseconds-since-epoch instant)))


(defn instant->seconds-since-epoch
  (^{:tag long} [instant]
  (tech.v3.datatype.datetime.base/instant->seconds-since-epoch instant)))


(defn instant->zoned-date-time
  (^{:tag java.time.ZonedDateTime} [inst zid]
  (tech.v3.datatype.datetime.base/instant->zoned-date-time inst zid))
  (^{:tag java.time.ZonedDateTime} [inst]
  (tech.v3.datatype.datetime.base/instant->zoned-date-time inst)))


(defn local-date
  (^{:tag java.time.LocalDate} []
  (tech.v3.datatype.datetime.base/local-date )))


(defn local-date->days-since-epoch
  (^{:tag long} [ld local-time zoneid]
  (tech.v3.datatype.datetime.base/local-date->days-since-epoch ld local-time zoneid))
  (^{:tag long} [ld zoneid]
  (tech.v3.datatype.datetime.base/local-date->days-since-epoch ld zoneid))
  (^{:tag long} [ld]
  (tech.v3.datatype.datetime.base/local-date->days-since-epoch ld)))


(defn local-date->epoch-months
  (^{:tag long} [ld]
  (tech.v3.datatype.datetime.base/local-date->epoch-months ld)))


(defn local-date->instant
  (^{:tag java.time.Instant} [ld lt zoneid-or-offset]
  (tech.v3.datatype.datetime.base/local-date->instant ld lt zoneid-or-offset))
  (^{:tag java.time.Instant} [ld zone-id]
  (tech.v3.datatype.datetime.base/local-date->instant ld zone-id))
  (^{:tag java.time.Instant} [ld]
  (tech.v3.datatype.datetime.base/local-date->instant ld)))


(defn local-date->local-date-time
  (^{:tag java.time.LocalDateTime} [ld lt]
  (tech.v3.datatype.datetime.base/local-date->local-date-time ld lt))
  (^{:tag java.time.LocalDateTime} [ld]
  (tech.v3.datatype.datetime.base/local-date->local-date-time ld)))


(defn local-date->milliseconds-since-epoch
  (^{:tag long} [ld lt zoneid]
  (tech.v3.datatype.datetime.base/local-date->milliseconds-since-epoch ld lt zoneid))
  (^{:tag long} [ld zoneid]
  (tech.v3.datatype.datetime.base/local-date->milliseconds-since-epoch ld zoneid))
  (^{:tag long} [ld]
  (tech.v3.datatype.datetime.base/local-date->milliseconds-since-epoch ld)))


(defn local-date->zoned-date-time
  (^{:tag java.time.Instant} [ld lt zoneid]
  (tech.v3.datatype.datetime.base/local-date->zoned-date-time ld lt zoneid))
  (^{:tag java.time.Instant} [ld zone-id]
  (tech.v3.datatype.datetime.base/local-date->zoned-date-time ld zone-id))
  (^{:tag java.time.Instant} [ld]
  (tech.v3.datatype.datetime.base/local-date->zoned-date-time ld)))


(defn local-date-time
  (^{:tag java.time.LocalDateTime} []
  (tech.v3.datatype.datetime.base/local-date-time ))
  (^{:tag java.time.LocalDateTime} [arg]
  (tech.v3.datatype.datetime.base/local-date-time arg)))


(defn local-date-time->instant
  (^{:tag java.time.Instant} [ldt zone-or-offset]
  (tech.v3.datatype.datetime.base/local-date-time->instant ldt zone-or-offset))
  (^{:tag java.time.Instant} [ldt]
  (tech.v3.datatype.datetime.base/local-date-time->instant ldt)))


(defn local-date-time->local-date
  (^{:tag java.time.LocalDate} [ldt]
  (tech.v3.datatype.datetime.base/local-date-time->local-date ldt)))


(defn local-date-time->local-time
  (^{:tag java.time.LocalTime} [ldt]
  (tech.v3.datatype.datetime.base/local-date-time->local-time ldt)))


(defn local-date-time->milliseconds-since-epoch
  (^{:tag long} [ldt timezone]
  (tech.v3.datatype.datetime.base/local-date-time->milliseconds-since-epoch ldt timezone))
  (^{:tag long} [ldt]
  (tech.v3.datatype.datetime.base/local-date-time->milliseconds-since-epoch ldt)))


(defn local-date-time->zoned-date-time
  (^{:tag java.time.Instant} [ldt zone-id]
  (tech.v3.datatype.datetime.base/local-date-time->zoned-date-time ldt zone-id))
  (^{:tag java.time.Instant} [ldt]
  (tech.v3.datatype.datetime.base/local-date-time->zoned-date-time ldt)))


(defn local-time
  (^{:tag java.time.LocalTime} []
  (tech.v3.datatype.datetime.base/local-time ))
  (^{:tag java.time.LocalTime} [arg]
  (tech.v3.datatype.datetime.base/local-time arg)))


(defn local-time->instant
  (^{:tag java.time.Instant} [lt]
  (tech.v3.datatype.datetime.base/local-time->instant lt))
  (^{:tag java.time.Instant} [lt ld]
  (tech.v3.datatype.datetime.base/local-time->instant lt ld)))


(defn local-time->local-date-time
  (^{:tag java.time.LocalDateTime} [ldt day]
  (tech.v3.datatype.datetime.base/local-time->local-date-time ldt day))
  (^{:tag java.time.LocalDateTime} [ldt]
  (tech.v3.datatype.datetime.base/local-time->local-date-time ldt)))


(defn local-time->milliseconds
  (^{:tag long} [lt]
  (tech.v3.datatype.datetime.base/local-time->milliseconds lt)))


(defn local-time->seconds
  (^{:tag long} [lt]
  (tech.v3.datatype.datetime.base/local-time->seconds lt)))


(defn long-temporal-field
  "Given a temporal field (or a keyword representing desired field)
  return an :int64 thing that represents that value of this temporal.
  Temporal fields are:
   #{:iso-day-of-week :iso-week-of-year :day-of-week :months :days :seconds
  :epoch-days :day-of-year :hours :years :milliseconds :minutes :week-of-year}.

  Not all temporal objects support all temporal fields.
  Also, if you are looking to convert a thing to seconds-since-epochs please
  see datetime->milliseconds."
  ([tf data]
  (tech.v3.datatype.datetime.operations/long-temporal-field tf data)))


(defn microseconds-since-epoch->instant
  (^{:tag java.time.Instant} [microseconds-since-epoch]
  (tech.v3.datatype.datetime.base/microseconds-since-epoch->instant microseconds-since-epoch)))


(defn millisecond-descriptive-statistics
  "Get the descriptive stats.  Stats are calulated in milliseconds and
  then min, mean, max are returned as objects of the unpacked datetime
  datatype.  Any other stats values are returned in milliseconds unless
  the input is a duration or packed duration type in which case standard
  deviation is also a duration datatype."
  ([stats-seq options data]
  (tech.v3.datatype.datetime.operations/millisecond-descriptive-statistics stats-seq options data))
  ([data]
  (tech.v3.datatype.datetime.operations/millisecond-descriptive-statistics data)))


(defn milliseconds->datetime
  "Vectorized Conversion of milliseconds to a given datetime datatype using defaults.
  Specialized conversions for particular datatypes also available as overrides or
  tech.v2.datatype.datetime/milliseconds-since-epoch->X where X can be:
  local-date local-date-time zoned-date-time."
  ([datatype timezone milli-data]
  (tech.v3.datatype.datetime.operations/milliseconds->datetime datatype timezone milli-data))
  ([datatype milli-data]
  (tech.v3.datatype.datetime.operations/milliseconds->datetime datatype milli-data)))


(defn milliseconds->duration
  (^{:tag java.time.Duration} [millis]
  (tech.v3.datatype.datetime.base/milliseconds->duration millis)))


(defn milliseconds->local-time
  (^{:tag java.time.LocalTime} [milliseconds]
  (tech.v3.datatype.datetime.base/milliseconds->local-time milliseconds)))


(def ^{:tag 'long} milliseconds-in-day tech.v3.datatype.datetime.constants/milliseconds-in-day)
(def ^{:tag 'long} milliseconds-in-hour tech.v3.datatype.datetime.constants/milliseconds-in-hour)
(def ^{:tag 'long} milliseconds-in-minute tech.v3.datatype.datetime.constants/milliseconds-in-minute)
(def ^{:tag 'long} milliseconds-in-second tech.v3.datatype.datetime.constants/milliseconds-in-second)
(def ^{:tag 'long} milliseconds-in-week tech.v3.datatype.datetime.constants/milliseconds-in-week)
(defn milliseconds-since-epoch->instant
  (^{:tag java.time.Instant} [arg]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->instant arg)))


(defn milliseconds-since-epoch->local-date
  (^{:tag java.time.LocalDate} [millis]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->local-date millis))
  (^{:tag java.time.LocalDate} [millis zone-id]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->local-date millis zone-id)))


(defn milliseconds-since-epoch->local-date-time
  (^{:tag java.time.LocalDateTime} [millis]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->local-date-time millis))
  (^{:tag java.time.LocalDateTime} [millis zone-id]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->local-date-time millis zone-id)))


(defn milliseconds-since-epoch->local-time
  (^{:tag java.time.LocalTime} [millis]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->local-time millis)))


(defn milliseconds-since-epoch->zoned-date-time
  (^{:tag java.time.ZonedDateTime} [zid timezone]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->zoned-date-time zid timezone))
  (^{:tag java.time.ZonedDateTime} [zid]
  (tech.v3.datatype.datetime.base/milliseconds-since-epoch->zoned-date-time zid)))


(defn minus-temporal-amount
  "Subtract a given temporal amount (in integers) to a temporal dataset.
  Valid temporal amounts are:
  #{:months :days :seconds :hours :years :milliseconds :minutes :weeks}"
  ([datetime-data long-data tf]
  (tech.v3.datatype.datetime.operations/minus-temporal-amount datetime-data long-data tf))
  ([datetime-data long-data]
  (tech.v3.datatype.datetime.operations/minus-temporal-amount datetime-data long-data)))


(defn nanoseconds->duration
  (^{:tag java.time.Duration} [nanos]
  (tech.v3.datatype.datetime.base/nanoseconds->duration nanos)))


(def ^{:tag 'long} nanoseconds-in-day tech.v3.datatype.datetime.constants/nanoseconds-in-day)
(def ^{:tag 'long} nanoseconds-in-hour tech.v3.datatype.datetime.constants/nanoseconds-in-hour)
(def ^{:tag 'long} nanoseconds-in-millisecond tech.v3.datatype.datetime.constants/nanoseconds-in-millisecond)
(def ^{:tag 'long} nanoseconds-in-minute tech.v3.datatype.datetime.constants/nanoseconds-in-minute)
(def ^{:tag 'long} nanoseconds-in-second tech.v3.datatype.datetime.constants/nanoseconds-in-second)
(def ^{:tag 'long} nanoseconds-in-week tech.v3.datatype.datetime.constants/nanoseconds-in-week)
(defn plus-temporal-amount
  "Add a given temporal amount (in integers) to a temporal dataset.
  Valid temporal amounts are:
  #{:months :days :seconds :hours :years :milliseconds :minutes :weeks}"
  ([datetime-data long-data tf]
  (tech.v3.datatype.datetime.operations/plus-temporal-amount datetime-data long-data tf))
  ([datetime-data long-data]
  (tech.v3.datatype.datetime.operations/plus-temporal-amount datetime-data long-data)))


(defn seconds->local-time
  (^{:tag java.time.LocalTime} [seconds]
  (tech.v3.datatype.datetime.base/seconds->local-time seconds)))


(def ^{:tag 'long} seconds-in-day tech.v3.datatype.datetime.constants/seconds-in-day)
(def ^{:tag 'long} seconds-in-hour tech.v3.datatype.datetime.constants/seconds-in-hour)
(def ^{:tag 'long} seconds-in-minute tech.v3.datatype.datetime.constants/seconds-in-minute)
(defn seconds-since-epoch->instant
  (^{:tag java.time.Instant} [seconds]
  (tech.v3.datatype.datetime.base/seconds-since-epoch->instant seconds)))


(defn system-zone-id
  (^{:tag java.time.ZoneId} []
  (tech.v3.datatype.datetime.base/system-zone-id )))


(defn system-zone-offset
  (^{:tag java.time.ZoneOffset} []
  (tech.v3.datatype.datetime.base/system-zone-offset )))


(defn utc-zone-id
  (^{:tag java.time.ZoneId} []
  (tech.v3.datatype.datetime.base/utc-zone-id )))


(defn utc-zone-offset
  (^{:tag java.time.ZoneOffset} []
  (tech.v3.datatype.datetime.base/utc-zone-offset )))


(defn variable-rolling-window-ranges
  "Given a reader of monotonically increasing source datetime data, return an
  iterable of ranges that describe the windows in index space.  There will be one
  window per source input and windows are applied in int64 microsecond space.  Be
  aware that windows near the end cannot possibly satisfy the windowing requirement.

  See options for tech.v3.datatype.rolling/variable-rolling-window-ranges for further
  options, of which stepsize may be of interest."
  ([src-data window-length units options]
  (tech.v3.datatype.datetime.operations/variable-rolling-window-ranges src-data window-length units options))
  ([src-data window-length units]
  (tech.v3.datatype.datetime.operations/variable-rolling-window-ranges src-data window-length units)))


(defn zoned-date-time
  (^{:tag java.time.ZonedDateTime} []
  (tech.v3.datatype.datetime.base/zoned-date-time ))
  (^{:tag java.time.ZonedDateTime} [arg]
  (tech.v3.datatype.datetime.base/zoned-date-time arg)))


(defn zoned-date-time->instant
  (^{:tag java.time.Instant} [zid]
  (tech.v3.datatype.datetime.base/zoned-date-time->instant zid))
  (^{:tag java.time.Instant} [zdt tz]
  (tech.v3.datatype.datetime.base/zoned-date-time->instant zdt tz)))


(defn zoned-date-time->milliseconds-since-epoch
  (^{:tag long} [zid]
  (tech.v3.datatype.datetime.base/zoned-date-time->milliseconds-since-epoch zid))
  (^{:tag long} [zdt zid]
  (tech.v3.datatype.datetime.base/zoned-date-time->milliseconds-since-epoch zdt zid)))


