/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.codec;

import clojure.lang.Keyword;
import cn.leancloud.play.codec.CastTypeException;
import cn.leancloud.play.codec.Codec;
import cn.leancloud.play.codec.CodecsManager;
import cn.leancloud.play.codec.ObjectThunk;
import cn.leancloud.play.collection.PlayObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class CastTypeUtils {
    public static String castToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Keyword) {
            return ((Keyword)value).getName();
        }
        return value.toString();
    }

    public static Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new CastTypeException("can not cast to byte, value : " + value);
    }

    public static Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        throw new CastTypeException("can not cast to char, value : " + value);
    }

    public static Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        throw new CastTypeException("can not cast to short, value : " + value);
    }

    public static Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw new CastTypeException("can not cast to float, value : " + value);
    }

    public static Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new CastTypeException("can not cast to double, value : " + value);
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static Long castToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new CastTypeException("can not cast to long, value : " + value);
    }

    public static Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new CastTypeException("can not cast to int, value : " + value);
    }

    public static byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return Base64.getDecoder().decode((String)value);
        }
        throw new CastTypeException("can not cast to int, value : " + value);
    }

    public static Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        throw new CastTypeException("can not cast to boolean, value : " + value);
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A a = clazz.getAnnotation(annotationClass);
        if (a != null) {
            return a;
        }
        if (clazz.getAnnotations().length > 0) {
            for (Annotation annotation : clazz.getAnnotations()) {
                a = annotation.annotationType().getAnnotation(annotationClass);
                if (a == null) continue;
                return a;
            }
        }
        return null;
    }

    public static <T> T cast(Object obj, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (obj == null) {
            if (clazz == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (clazz == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (clazz == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (clazz == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (clazz == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (clazz == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (clazz == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            if (clazz == PlayObject.class) {
                return (T)PlayObject.toPlayObject((Map)obj);
            }
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = CastTypeUtils.cast(item, clazz.getComponentType());
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)CastTypeUtils.castToBytes(obj);
            }
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        Codec codec = CodecsManager.getInstance().getCodec(clazz);
        if (codec != null && obj instanceof ObjectThunk) {
            ObjectThunk thunk = (ObjectThunk)obj;
            if (CodecsManager.getInstance().getObjectTypeId(clazz).byteValue() == thunk.getObjectTypeId()) {
                return thunk.resolve(codec);
            }
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)CastTypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)CastTypeUtils.castToByte(obj);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return (T)CastTypeUtils.castToChar(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)CastTypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)CastTypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)CastTypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)CastTypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)CastTypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)CastTypeUtils.castToString(obj);
        }
        throw new CastTypeException("can not cast to: " + clazz.getName());
    }
}

