/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.codec;

import cn.leancloud.play.codec.Codec;
import cn.leancloud.play.codec.DeserializationException;
import cn.leancloud.play.codec.PlayArrayCodec;
import cn.leancloud.play.codec.PlayObjectCodec;
import cn.leancloud.play.codec.SerializationException;
import cn.leancloud.play.collection.PlayArray;
import cn.leancloud.play.collection.PlayObject;
import java.util.IdentityHashMap;
import java.util.Objects;

public final class CodecsManager {
    private static final CodecsManager instance = new CodecsManager();
    private final IdentityHashMap<Class<?>, Codec> registeredCodec = new IdentityHashMap();

    public static CodecsManager getInstance() {
        return instance;
    }

    public void registerCodec(Class<?> type, Codec codec) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(codec);
        this.registeredCodec.put(type, codec);
    }

    public Codec getCodec(Class<?> type) {
        return this.registeredCodec.get(type);
    }

    public byte[] serialize(Object obj) {
        Codec codec = this.registeredCodec.get(obj.getClass());
        if (codec != null) {
            return codec.serialize(obj);
        }
        throw new SerializationException(String.format("No codec for class %s", obj.getClass().getName()));
    }

    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        Codec codec = this.registeredCodec.get(clazz);
        if (codec != null) {
            return codec.deserialize(bytes);
        }
        throw new DeserializationException(String.format("No codec for class %s", clazz.getClass().getName()));
    }

    static {
        CodecsManager.getInstance().registerCodec(PlayObject.class, new PlayObjectCodec());
        CodecsManager.getInstance().registerCodec(PlayArray.class, new PlayArrayCodec());
    }
}

