/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import java.util.ArrayList;
import java.util.List;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E> {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList(new ArrayList(0));
    private final List<E> list;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new ArrayList(10));
    }

    private ProtobufArrayList(List<E> list) {
        this.list = list;
    }

    @Override
    public ProtobufArrayList<E> mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> newList = new ArrayList<E>(capacity);
        newList.addAll(this.list);
        return new ProtobufArrayList(newList);
    }

    @Override
    public void add(int index2, E element) {
        this.ensureIsMutable();
        this.list.add(index2, element);
        ++this.modCount;
    }

    @Override
    public E get(int index2) {
        return this.list.get(index2);
    }

    @Override
    public E remove(int index2) {
        this.ensureIsMutable();
        E toReturn = this.list.remove(index2);
        ++this.modCount;
        return toReturn;
    }

    @Override
    public E set(int index2, E element) {
        this.ensureIsMutable();
        E toReturn = this.list.set(index2, element);
        ++this.modCount;
        return toReturn;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

