/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import cn.leancloud.play.plugin.request.AbstractRequest;
import cn.leancloud.play.plugin.request.RoomSystemProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SetRoomSystemPropertiesRequest
extends AbstractRequest {
    private static final Keyword sysAttrK = RT.keyword(null, (String)"sys-attr");

    public SetRoomSystemPropertiesRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public Optional<OpenRoomProperty> getOpenRoomProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        Boolean valueToSet = (Boolean)oldProps.get(OpenRoomProperty.propertyKey);
        if (valueToSet != null) {
            return Optional.of(OpenRoomProperty.set(valueToSet));
        }
        return Optional.empty();
    }

    public SetRoomSystemPropertiesRequest setOpenRoomProperty(OpenRoomProperty property) {
        Objects.requireNonNull(property);
        if (property.getPropertyValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(OpenRoomProperty.propertyKey, property.getSerializedPropertyValue());
            this.setProperties(oldProps);
        }
        return this;
    }

    public Optional<ExposeRoomProperty> getExposeRoomProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        Boolean valueToSet = (Boolean)oldProps.get(ExposeRoomProperty.propertyKey);
        if (valueToSet != null) {
            return Optional.of(ExposeRoomProperty.set(valueToSet));
        }
        return Optional.empty();
    }

    public SetRoomSystemPropertiesRequest setExposeRoomProperty(ExposeRoomProperty property) {
        Objects.requireNonNull(property);
        if (property.getPropertyValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(ExposeRoomProperty.propertyKey, property.getSerializedPropertyValue());
            this.setProperties(oldProps);
        }
        return this;
    }

    public Optional<ExpectedUserIdsProperty> getExpectedUserIdsProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        Map valueToSet = (Map)oldProps.get(ExpectedUserIdsProperty.propertyKey);
        if (valueToSet != null && !valueToSet.isEmpty()) {
            Map.Entry entry = valueToSet.entrySet().iterator().next();
            Operator op = Operator.findOperator((Keyword)entry.getKey());
            ExpectedUserIdsProperty property = new ExpectedUserIdsProperty(op, new HashSet((Collection)entry.getValue()));
            return Optional.of(property);
        }
        return Optional.empty();
    }

    public SetRoomSystemPropertiesRequest setExpectedUserIdsProperty(ExpectedUserIdsProperty property) {
        Objects.requireNonNull(property);
        if (property.getPropertyValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(ExpectedUserIdsProperty.propertyKey, property.getSerializedPropertyValue());
            this.setProperties(oldProps);
        }
        return this;
    }

    public SetRoomSystemPropertiesRequest setMaxPlayerCountProperty(MaxPlayerCountProperty property) {
        Objects.requireNonNull(property);
        if (property.getPropertyValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(MaxPlayerCountProperty.propertyKey, property.getSerializedPropertyValue());
            this.setProperties(oldProps);
        }
        return this;
    }

    public Optional<MaxPlayerCountProperty> getMaxPlayerCountProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        Number valueToSet = (Number)oldProps.get(MaxPlayerCountProperty.propertyKey);
        if (valueToSet != null) {
            return Optional.of(MaxPlayerCountProperty.set(valueToSet.intValue()));
        }
        return Optional.empty();
    }

    private void setProperties(Map<Keyword, Object> attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(sysAttrK, PersistentHashMap.create(attr));
    }

    private Map<Keyword, Object> getProperties() {
        return this.getParameter(sysAttrK, Collections.emptyMap());
    }

    public String toString() {
        StringBuilder propertyStrBuilder = new StringBuilder();
        for (Optional property : Arrays.asList(this.getOpenRoomProperty(), this.getExposeRoomProperty(), this.getExpectedUserIdsProperty(), this.getMaxPlayerCountProperty())) {
            if (!property.isPresent()) continue;
            propertyStrBuilder.append(", {");
            propertyStrBuilder.append(property.get());
            propertyStrBuilder.append("}");
        }
        return "SetRoomSystemPropertiesRequest{roomName=" + this.getRoomName() + ", userId=" + this.getUserId() + propertyStrBuilder.toString() + "}";
    }

    public static final class MaxPlayerCountProperty
    implements RoomSystemProperty<Integer> {
        private static Keyword propertyKey = RT.keyword(null, (String)"maxMembers");
        private final int valueToSet;

        private MaxPlayerCountProperty(int valueToSet) {
            this.valueToSet = valueToSet;
        }

        public static MaxPlayerCountProperty set(int playerCount) {
            return new MaxPlayerCountProperty(playerCount);
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public Integer getPropertyValueToSet() {
            return this.valueToSet;
        }

        public String toString() {
            return "maxPlayerCount=" + this.valueToSet;
        }
    }

    public static final class OpenRoomProperty
    implements RoomSystemProperty<Boolean> {
        private static Keyword propertyKey = RT.keyword(null, (String)"open");
        private final boolean valueToSet;

        private OpenRoomProperty(Boolean valueToSet) {
            Objects.requireNonNull(valueToSet);
            this.valueToSet = valueToSet;
        }

        public static OpenRoomProperty set(boolean valueToSet) {
            return new OpenRoomProperty(valueToSet);
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public Boolean getPropertyValueToSet() {
            return this.valueToSet;
        }

        public String toString() {
            return "openRoom=" + this.valueToSet;
        }
    }

    public static final class ExposeRoomProperty
    implements RoomSystemProperty<Boolean> {
        private static Keyword propertyKey = RT.keyword(null, (String)"visible");
        private final boolean valueToSet;

        private ExposeRoomProperty(Boolean valueToSet) {
            Objects.requireNonNull(valueToSet);
            this.valueToSet = valueToSet;
        }

        public static ExposeRoomProperty set(boolean valueToSet) {
            return new ExposeRoomProperty(valueToSet);
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public Boolean getPropertyValueToSet() {
            return this.valueToSet;
        }

        public String toString() {
            return "visible=" + this.valueToSet;
        }
    }

    public static final class ExpectedUserIdsProperty
    implements RoomSystemProperty<Set<String>> {
        private static Keyword propertyKey = RT.keyword(null, (String)"expectMembers");
        private final Operator operator;
        private final Set<String> valueToSet;

        private ExpectedUserIdsProperty(Operator op, Set<String> valueToSet) {
            this.operator = op;
            this.valueToSet = Collections.unmodifiableSet(new HashSet<String>(valueToSet));
        }

        public static ExpectedUserIdsProperty add(Set<String> valueToSet) {
            Objects.requireNonNull(valueToSet);
            return new ExpectedUserIdsProperty(Operator.ADD, valueToSet);
        }

        public static ExpectedUserIdsProperty remove(Set<String> valueToSet) {
            Objects.requireNonNull(valueToSet);
            return new ExpectedUserIdsProperty(Operator.REMOVE, valueToSet);
        }

        public static ExpectedUserIdsProperty set(Set<String> valueToSet) {
            Objects.requireNonNull(valueToSet);
            return new ExpectedUserIdsProperty(Operator.SET, valueToSet);
        }

        public static ExpectedUserIdsProperty drop() {
            return new ExpectedUserIdsProperty(Operator.DROP, Collections.emptySet());
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public Set<String> getPropertyValueToSet() {
            return this.valueToSet;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public Object getSerializedPropertyValue() {
            HashMap<Keyword, Set<String>> m = new HashMap<Keyword, Set<String>>();
            m.put(this.operator.key, this.valueToSet);
            return m;
        }

        public String toString() {
            return "operator=" + this.getOperator().name() + ", expectedUserIds=" + this.valueToSet;
        }
    }

    public static enum Operator {
        ADD(RT.keyword(null, (String)"$add")),
        REMOVE(RT.keyword(null, (String)"$remove")),
        SET(RT.keyword(null, (String)"$set")),
        DROP(RT.keyword(null, (String)"$drop"));

        private final Keyword key;

        private Operator(Keyword k) {
            this.key = k;
        }

        static Operator findOperator(Keyword k) {
            for (Operator op : Operator.values()) {
                if (op.key != k) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator for keyword: " + k);
        }
    }
}

