/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.collection.PlayObject;
import cn.leancloud.play.plugin.request.AbstractRequest;
import cn.leancloud.play.plugin.request.CacheOption;
import cn.leancloud.play.plugin.request.ReceiverGroup;
import cn.leancloud.play.utils.Log;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SendEventRequest
extends AbstractRequest {
    private static final Keyword cacheOptionK = RT.keyword(null, "cache-option");
    private static final Keyword receiverGroupK = RT.keyword(null, "receiver-group");
    private static final Keyword toActorsK = RT.keyword(null, "to-actors");
    private static final Keyword dataK = RT.keyword(null, "data");
    private static final Keyword eventIdK = RT.keyword(null, "event-id");
    private static final Keyword fromActorIdK = RT.keyword(null, "from-actor-id");

    public SendEventRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public CacheOption getCacheOption() {
        Number opt = (Number)this.getParameter(cacheOptionK);
        if (opt != null) {
            return CacheOption.of(opt.byteValue());
        }
        return CacheOption.NO_CACHE;
    }

    public SendEventRequest setCacheOption(CacheOption opt) {
        Objects.requireNonNull(opt);
        this.setParameter(cacheOptionK, opt.getCode());
        return this;
    }

    public ReceiverGroup getReceiverGroup() {
        Number gp = (Number)this.getParameter(receiverGroupK);
        if (gp != null) {
            return ReceiverGroup.of(gp.byteValue());
        }
        return ReceiverGroup.OTHERS;
    }

    public SendEventRequest setReceiverGroup(ReceiverGroup group) {
        Objects.requireNonNull(group);
        this.setParameter(receiverGroupK, group.getCode());
        return this;
    }

    public List<Integer> getTargetActorIds() {
        List actors = (List)this.getParameter(toActorsK);
        if (actors != null) {
            return actors.stream().map(Number::intValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public SendEventRequest setTargetActorIds(List<Integer> actorIds) {
        Objects.requireNonNull(actorIds);
        this.setParameter(toActorsK, PersistentVector.create(actorIds));
        return this;
    }

    public PlayObject getEventData() {
        Object data2 = this.getParameter(dataK);
        if (data2 == null) {
            return PlayObject.EMPTY_OBJECT;
        }
        return (PlayObject)data2;
    }

    public SendEventRequest setEventData(PlayObject data2) {
        if (data2 == null) {
            data2 = PlayObject.EMPTY_OBJECT;
        }
        this.setParameter(dataK, data2);
        return this;
    }

    public byte getEventId() {
        Number id = (Number)this.getParameter(eventIdK);
        if (id != null) {
            return id.byteValue();
        }
        throw new IllegalArgumentException(String.format("eventId is required for %s", SendEventRequest.class));
    }

    public int getFromActorId() {
        Number id = (Number)this.getParameter(fromActorIdK);
        if (id != null) {
            return id.intValue();
        }
        Log.error("No from actor id in {}. current params={}", (Object)SendEventRequest.class.getSimpleName(), this.getAllInternalParameters());
        return -1;
    }

    public String toString() {
        return "SendEventRequest{roomName=" + this.getRoomName() + ", userId=" + this.getUserId() + ", eventId=" + this.getEventId() + ", fromActorId=" + this.getFromActorId() + ", targetActorIds=" + this.getTargetActorIds() + ", receiverGroup=" + this.getReceiverGroup().name() + ", cacheOptions=" + this.getCacheOption().name() + ", eventData=" + this.getEventData() + "}";
    }
}

