/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.collection.PlayObject;
import cn.leancloud.play.plugin.request.AbstractRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class CreateRoomRequest
extends AbstractRequest {
    private static final Keyword maxMembersK = RT.keyword(null, "max-members");
    private static final Keyword emptyRoomTtlK = RT.keyword(null, "empty-room-ttl");
    private static final Keyword playerTtlK = RT.keyword(null, "player-ttl");
    private static final Keyword expectMK = RT.keyword(null, "expect-m");
    private static final Keyword isVisibleK = RT.keyword(null, "visible?");
    private static final Keyword lobbyKeysK = RT.keyword(null, "lobby-keys");
    private static final Keyword attrK = RT.keyword(null, "attr");
    private static final Keyword flagK = RT.keyword(null, "conv-flag");

    public CreateRoomRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public int getMaxPlayerCount() {
        return this.getParameter(maxMembersK, 10);
    }

    public CreateRoomRequest setMaxPlayerCount(int max2) {
        if (max2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.setParameter(maxMembersK, max2);
        return this;
    }

    public int getEmptyRoomTtlSecs() {
        return this.getParameter(emptyRoomTtlK, 0);
    }

    public CreateRoomRequest setEmptyRoomTtl(long ttl, TimeUnit unit) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException();
        }
        this.setParameter(emptyRoomTtlK, (int)unit.toSeconds(ttl));
        return this;
    }

    public int getPlayerTtlSecs() {
        return this.getParameter(playerTtlK, 0);
    }

    public CreateRoomRequest setPlayerTtl(long ttl, TimeUnit unit) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException();
        }
        this.setParameter(playerTtlK, (int)unit.toSeconds(ttl));
        return this;
    }

    public List<String> getExpectedUserIds() {
        return this.getParameter(expectMK, Collections.emptyList());
    }

    public CreateRoomRequest setExpectUsers(List<String> expectUsers) {
        Objects.requireNonNull(expectUsers);
        if (expectUsers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectMK, PersistentVector.create(expectUsers));
        return this;
    }

    public boolean isVisible() {
        return this.getParameter(isVisibleK, true);
    }

    public CreateRoomRequest hideRoom() {
        this.setParameter(isVisibleK, false);
        return this;
    }

    public CreateRoomRequest exposeRoom() {
        this.setParameter(isVisibleK, true);
        return this;
    }

    public List<String> getCustomRoomPropertyKeysForLobby() {
        return this.getParameter(lobbyKeysK, Collections.emptyList());
    }

    public CreateRoomRequest setLobbyKeys(List<String> keys2) {
        Objects.requireNonNull(keys2);
        if (keys2.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(lobbyKeysK, PersistentVector.create(keys2));
        return this;
    }

    public PlayObject getCustomRoomProperties() {
        return this.getParameter(attrK, PlayObject.EMPTY_OBJECT);
    }

    public CreateRoomRequest setRoomProperties(PlayObject attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attrK, attr.clone());
        return this;
    }

    public String toString() {
        return "CreateRoomRequest{roomName=" + this.getRoomName() + ", userId=" + this.getUserId() + ", expectUserIds=" + this.getExpectedUserIds() + ", emptyRoomTtl=" + this.getEmptyRoomTtlSecs() + ", maxPlayerCount=" + this.getMaxPlayerCount() + ", playerTtl=" + this.getPlayerTtlSecs() + ", visible=" + this.isVisible() + ", flag=" + this.getParameter(flagK, 0) + ", customRoomProperties=" + this.getCustomRoomProperties() + ", customRoomPropertyKeysForLobby=" + this.getCustomRoomPropertyKeysForLobby() + "}";
    }
}

