/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.codec;

import cn.leancloud.play.codec.CastTypeException;
import cn.leancloud.play.codec.CodecsManager;
import cn.leancloud.play.collection.PlayArray;
import cn.leancloud.play.collection.PlayObject;
import cn.leancloud.play.proto.GenericCollectionValue;
import com.google.protobuf.ByteString;

final class CollectionThunk {
    private final GenericCollectionValue.Type type;
    private final ByteString byteString;

    CollectionThunk(GenericCollectionValue.Type type2, ByteString byteString) {
        this.type = type2;
        this.byteString = byteString;
    }

    ByteString getByteString() {
        return this.byteString;
    }

    GenericCollectionValue.Type getType() {
        return this.type;
    }

    PlayObject getPlayObject() {
        if (this.getType() == GenericCollectionValue.Type.MAP) {
            return CodecsManager.deserialize(this.getByteString().toByteArray(), PlayObject.class);
        }
        throw new CastTypeException("can not cast to PlayObject, actual collection type: '" + this.getType().name() + "'");
    }

    PlayArray getPlayArray() {
        if (this.getType() == GenericCollectionValue.Type.ARRAY) {
            return CodecsManager.deserialize(this.getByteString().toByteArray(), PlayArray.class);
        }
        throw new CastTypeException("can not cast to PlayArray, actual collection type: '" + this.getType().name() + "'");
    }
}

