/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.RT;
import cn.leancloud.play.collection.GameMap;
import cn.leancloud.play.plugin.request.AbstractRequest;
import cn.leancloud.play.utils.Log;
import java.util.Map;
import java.util.Objects;

public final class SetPlayerPropertiesRequest
extends AbstractRequest {
    private static final Keyword targetActorIdK = RT.keyword(null, (String)"target-actor-id");
    private static final Keyword expectAttrK = RT.keyword(null, (String)"expect-attr");
    private static final Keyword attrK = RT.keyword(null, (String)"attr");

    public SetPlayerPropertiesRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public GameMap getProperties() {
        return this.getParameter(attrK, GameMap.EMPTY_MAP);
    }

    public SetPlayerPropertiesRequest setProperties(GameMap attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attrK, attr.clone());
        return this;
    }

    public GameMap getExpectedValues() {
        return this.getParameter(expectAttrK, GameMap.EMPTY_MAP);
    }

    public SetPlayerPropertiesRequest setExpectedValues(GameMap casAttr) {
        Objects.requireNonNull(casAttr);
        if (casAttr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectAttrK, casAttr.clone());
        return this;
    }

    public int getTargetActorId() {
        Number id = (Number)this.getParameter(targetActorIdK);
        if (id != null) {
            return id.intValue();
        }
        Log.error("No target actor id in {}. current params={}", (Object)SetPlayerPropertiesRequest.class.getSimpleName(), this.getAllInternalParameters());
        return -1;
    }

    public SetPlayerPropertiesRequest setTargetActorId(int actorId) {
        this.setParameter(targetActorIdK, actorId);
        return this;
    }
}

