/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.collection.GameMap;
import cn.leancloud.play.plugin.request.AbstractRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JoinRoomRequest
extends AbstractRequest {
    private static final Keyword expectMK = RT.keyword(null, (String)"expect-m");
    private static final Keyword isRejoinK = RT.keyword(null, (String)"rejoin?");
    private static final Keyword expectAttrK = RT.keyword(null, (String)"expect-attr");
    private static final Keyword attrK = RT.keyword(null, (String)"attr");

    public JoinRoomRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public List<String> getExpectUsers() {
        return this.getParameter(expectMK, Collections.emptyList());
    }

    public JoinRoomRequest setExpectUsers(List<String> expectUsers) {
        Objects.requireNonNull(expectUsers);
        if (expectUsers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectMK, PersistentVector.create(expectUsers));
        return this;
    }

    public boolean isRejoin() {
        return this.getParameter(isRejoinK, false);
    }

    public GameMap getMatchProperties() {
        return this.getParameter(expectAttrK, GameMap.EMPTY_MAP);
    }

    public JoinRoomRequest setMatchProperties(GameMap attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectAttrK, attr.clone());
        return this;
    }

    public GameMap getActorProperties() {
        return this.getParameter(attrK, GameMap.EMPTY_MAP);
    }

    public JoinRoomRequest setActorProperties(GameMap attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attrK, attr.clone());
        return this;
    }
}

