/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.context;

import cn.leancloud.play.plugin.HookResponse;
import cn.leancloud.play.plugin.Reason;
import cn.leancloud.play.plugin.context.Context;
import cn.leancloud.play.plugin.context.ContextStatus;
import cn.leancloud.play.plugin.request.RoomRequest;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class AbstractOperationContext<T extends RoomRequest>
implements Context<T> {
    private final CompletableFuture<HookResponse<T>> future;
    private final T req;
    private final Thread bindingThread;
    private ContextStatus status;

    AbstractOperationContext(T req, CompletableFuture<HookResponse<T>> future2) {
        Objects.requireNonNull(req);
        Objects.requireNonNull(future2);
        this.req = req;
        this.future = future2;
        this.status = ContextStatus.NEW;
        this.bindingThread = Thread.currentThread();
    }

    @Override
    public ContextStatus getStatus() {
        return this.status;
    }

    @Override
    public T getRequest() {
        return this.req;
    }

    @Override
    public void continueProcess() {
        this.updateStatusWhenNotProcessed(ContextStatus.CONTINUED);
        this.completeHookFuture(HookResponse.success(this.req));
    }

    @Override
    public void rejectProcess(Reason reason) {
        this.updateStatusWhenNotProcessed(ContextStatus.REJECTED);
        this.completeHookFuture(HookResponse.reject(reason));
    }

    @Override
    public boolean isProcessed() {
        return this.status.getCode() > ContextStatus.DEFERRED.getCode();
    }

    void updateStatusWhenNotProcessed(ContextStatus newStatus) {
        if (this.isProcessed()) {
            throw new IllegalStateException("request already processed");
        }
        if (Thread.currentThread() != this.bindingThread) {
            String msg = "Context can only be operated by it's binding thread. Please use the scheduler in BoundRoomto submit a task to operate this Context.";
            throw new ConcurrentModificationException(msg);
        }
        this.status = newStatus;
    }

    void completeHookFuture(HookResponse<T> response) {
        this.req.setReadOnly();
        this.future.complete(response);
    }
}

