/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.collection;

import cn.leancloud.play.collection.GameArray;
import cn.leancloud.play.utils.CastTypeException;
import cn.leancloud.play.utils.CastTypeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GameMap
implements Map<String, Object>,
Cloneable,
Serializable {
    public static final GameMap EMPTY_MAP = new GameMap(Collections.emptyMap());
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public GameMap() {
        this(16);
    }

    public GameMap(Map<Object, Object> map2) {
        this.map = GameMap.toGameMap(map2);
    }

    public GameMap(int initialCapacity) {
        this.map = new HashMap<String, Object>(initialCapacity);
    }

    public static GameMap toGameMap(Map<Object, Object> inputMap) {
        if (inputMap == null) {
            return EMPTY_MAP;
        }
        GameMap map2 = new GameMap(inputMap.size());
        for (Map.Entry<Object, Object> entry : inputMap.entrySet()) {
            Object key2 = entry.getKey();
            String keyInStr = CastTypeUtils.castToString(key2);
            Object v = entry.getValue();
            map2.put(keyInStr, v);
        }
        return map2;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key2) {
        return this.map.get(key2);
    }

    @Override
    public Object put(String key2, Object value) {
        return this.map.put(key2, value);
    }

    public GameMap fluentPut(String key2, Object value) {
        this.map.put(key2, value);
        return this;
    }

    @Override
    public Object remove(Object key2) {
        return this.map.remove(key2);
    }

    public GameMap fluentRemove(Object key2) {
        this.map.remove(key2);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
    }

    public GameMap fluentPutAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public GameMap fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new GameMap(new HashMap<Object, Object>(this.map));
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public GameMap getGameMap(String key2) {
        Object value = this.map.get(key2);
        if (value == null) {
            return null;
        }
        if (value instanceof GameMap) {
            return (GameMap)value;
        }
        if (value instanceof Map) {
            return GameMap.toGameMap((Map)value);
        }
        throw new CastTypeException("can not cast to GameMap, value : '" + value + "'");
    }

    public GameArray getGameArray(String key2) {
        Object value = this.map.get(key2);
        if (value == null) {
            return null;
        }
        if (value instanceof GameArray) {
            return (GameArray)value;
        }
        if (value instanceof List) {
            return GameArray.toGameArray((List)value);
        }
        throw new CastTypeException("can not cast to GameArray, value : '" + value + "'");
    }

    public <T> T getObject(String key2, Class<T> clazz) {
        Object obj = this.map.get(key2);
        return CastTypeUtils.cast(obj, clazz);
    }

    public Boolean getBoolean(String key2) {
        Object value = this.get(key2);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBoolean(value);
    }

    public byte[] getBytes(String key2) {
        Object value = this.get(key2);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBytes(value);
    }

    public boolean getBooleanValue(String key2) {
        Object value = this.get(key2);
        Boolean booleanVal = CastTypeUtils.castToBoolean(value);
        if (booleanVal == null) {
            return false;
        }
        return booleanVal;
    }

    public Byte getByte(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToByte(value);
    }

    public byte getByteValue(String key2) {
        Object value = this.get(key2);
        Byte byteVal = CastTypeUtils.castToByte(value);
        if (byteVal == null) {
            return 0;
        }
        return byteVal;
    }

    public Short getShort(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToShort(value);
    }

    public short getShortValue(String key2) {
        Object value = this.get(key2);
        Short shortVal = CastTypeUtils.castToShort(value);
        if (shortVal == null) {
            return 0;
        }
        return shortVal;
    }

    public Integer getInteger(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToInt(value);
    }

    public int getIntValue(String key2) {
        Object value = this.get(key2);
        Integer intVal = CastTypeUtils.castToInt(value);
        if (intVal == null) {
            return 0;
        }
        return intVal;
    }

    public Long getLong(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToLong(value);
    }

    public long getLongValue(String key2) {
        Object value = this.get(key2);
        Long longVal = CastTypeUtils.castToLong(value);
        if (longVal == null) {
            return 0L;
        }
        return longVal;
    }

    public Float getFloat(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToFloat(value);
    }

    public float getFloatValue(String key2) {
        Object value = this.get(key2);
        Float floatValue = CastTypeUtils.castToFloat(value);
        if (floatValue == null) {
            return 0.0f;
        }
        return floatValue.floatValue();
    }

    public Double getDouble(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToDouble(value);
    }

    public double getDoubleValue(String key2) {
        Object value = this.get(key2);
        Double doubleValue = CastTypeUtils.castToDouble(value);
        if (doubleValue == null) {
            return 0.0;
        }
        return doubleValue;
    }

    public BigDecimal getBigDecimal(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(String key2) {
        Object value = this.get(key2);
        return CastTypeUtils.castToBigInteger(value);
    }

    public String getString(String key2) {
        Object value = this.get(key2);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    public String toString() {
        return "GameMap{" + this.map + '}';
    }
}

