/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.collection;

import cn.leancloud.play.collection.GameMap;
import cn.leancloud.play.utils.CastTypeException;
import cn.leancloud.play.utils.CastTypeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;

public final class GameArray
implements List<Object>,
Cloneable,
RandomAccess,
Serializable {
    public static final GameArray EMPTY_ARRAY = new GameArray(Collections.emptyList());
    private static final long serialVersionUID = 1L;
    private final List<Object> list;

    public GameArray() {
        this.list = new ArrayList<Object>();
    }

    public GameArray(List<Object> list) {
        this.list = list;
    }

    public GameArray(int initialCapacity) {
        this.list = new ArrayList<Object>(initialCapacity);
    }

    public static GameArray toGameArray(List<Object> list) {
        if (list == null) {
            return EMPTY_ARRAY;
        }
        return new GameArray(list);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        return this.list.add(o);
    }

    public GameArray fluentAdd(Object o) {
        this.list.add(o);
        return this;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    public GameArray fluentRemove(Object o) {
        this.list.remove(o);
        return this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        return this.list.addAll(c);
    }

    public GameArray fluentAddAll(Collection<?> c) {
        this.list.addAll(c);
        return this;
    }

    @Override
    public boolean addAll(int index2, Collection<?> c) {
        return this.list.addAll(index2, c);
    }

    public GameArray fluentAddAll(int index2, Collection<?> c) {
        this.list.addAll(index2, c);
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    public GameArray fluentRemoveAll(Collection<?> c) {
        this.list.removeAll(c);
        return this;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    public GameArray fluentRetainAll(Collection<?> c) {
        this.list.retainAll(c);
        return this;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public GameArray fluentClear() {
        this.list.clear();
        return this;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index2) {
        return this.list.listIterator(index2);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object get(int index2) {
        return this.list.get(index2);
    }

    @Override
    public Object set(int index2, Object element) {
        if (index2 == -1) {
            this.list.add(element);
            return null;
        }
        if (this.list.size() <= index2) {
            for (int i = this.list.size(); i < index2; ++i) {
                this.list.add(null);
            }
            this.list.add(element);
            return null;
        }
        return this.list.set(index2, element);
    }

    public GameArray fluentSet(int index2, Object element) {
        this.set(index2, element);
        return this;
    }

    @Override
    public void add(int index2, Object element) {
        this.list.add(index2, element);
    }

    public GameArray fluentAdd(int index2, Object element) {
        this.list.add(index2, element);
        return this;
    }

    @Override
    public Object remove(int index2) {
        return this.list.remove(index2);
    }

    public GameArray fluentRemove(int index2) {
        this.list.remove(index2);
        return this;
    }

    public Object clone() {
        return new GameArray(new ArrayList<Object>(this.list));
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public GameMap getGameMap(int index2) {
        Object value = this.list.get(index2);
        if (value == null) {
            return null;
        }
        if (value instanceof GameMap) {
            return (GameMap)value;
        }
        if (value instanceof Map) {
            return GameMap.toGameMap((Map)value);
        }
        throw new CastTypeException("can not cast to GameMap, value : '" + value + "'");
    }

    public GameArray getGameArray(int index2) {
        Object value = this.list.get(index2);
        if (value == null) {
            return null;
        }
        if (value instanceof GameArray) {
            return (GameArray)value;
        }
        if (value instanceof List) {
            return GameArray.toGameArray(this.list);
        }
        throw new CastTypeException("can not cast to GameArray, value : '" + value + "'");
    }

    public <T> T getObject(int index2, Class<T> clazz) {
        Object value = this.list.get(index2);
        return CastTypeUtils.cast(value, clazz);
    }

    public Boolean getBoolean(int index2) {
        Object value = this.get(index2);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBoolean(value);
    }

    public boolean getBooleanValue(int index2) {
        Object value = this.get(index2);
        Boolean boolV = CastTypeUtils.castToBoolean(value);
        if (boolV == null) {
            return false;
        }
        return boolV;
    }

    public Byte getByte(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToByte(value);
    }

    public byte getByteValue(int index2) {
        Object value = this.get(index2);
        Byte bValue = CastTypeUtils.castToByte(value);
        if (value == null) {
            return 0;
        }
        return bValue;
    }

    public byte[] getBytes(int index2) {
        Object value = this.get(index2);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBytes(value);
    }

    public Short getShort(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToShort(value);
    }

    public short getShortValue(int index2) {
        Object value = this.get(index2);
        Short sValue = CastTypeUtils.castToShort(value);
        if (sValue == null) {
            return 0;
        }
        return sValue;
    }

    public Integer getInteger(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToInt(value);
    }

    public int getIntValue(int index2) {
        Object value = this.get(index2);
        Integer intValue = CastTypeUtils.castToInt(value);
        if (intValue == null) {
            return 0;
        }
        return intValue;
    }

    public Long getLong(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToLong(value);
    }

    public long getLongValue(int index2) {
        Object value = this.get(index2);
        Long lVal = CastTypeUtils.castToLong(value);
        if (lVal == null) {
            return 0L;
        }
        return lVal;
    }

    public Float getFloat(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToFloat(value);
    }

    public float getFloatValue(int index2) {
        Object value = this.get(index2);
        Float fVal = CastTypeUtils.castToFloat(value);
        if (fVal == null) {
            return 0.0f;
        }
        return fVal.floatValue();
    }

    public Double getDouble(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToDouble(value);
    }

    public double getDoubleValue(int index2) {
        Object value = this.get(index2);
        Double dVal = CastTypeUtils.castToDouble(value);
        if (dVal == null) {
            return 0.0;
        }
        return dVal;
    }

    public BigDecimal getBigDecimal(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToBigInteger(value);
    }

    public String getString(int index2) {
        Object value = this.get(index2);
        return CastTypeUtils.castToString(value);
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>(this.size());
        for (Object item : this) {
            T classItem = CastTypeUtils.cast(item, clazz);
            list.add(classItem);
        }
        return list;
    }

    public List<Object> getInnerList() {
        return this.list;
    }

    public String toString() {
        return "GameArray{" + this.list + '}';
    }
}

