/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.codec;

import cn.leancloud.play.codec.Codec;
import cn.leancloud.play.codec.DeserializationException;
import cn.leancloud.play.codec.SerializationException;
import java.util.IdentityHashMap;
import java.util.Objects;

public class CodecsManager {
    private static final CodecsManager instance = new CodecsManager();
    private final IdentityHashMap<Class<?>, Codec> registeredCodec = new IdentityHashMap();

    public static CodecsManager getInstance() {
        return instance;
    }

    public void registerCodec(Class<?> type2, Codec codec) {
        Objects.requireNonNull(type2);
        Objects.requireNonNull(codec);
        this.registeredCodec.put(type2, codec);
    }

    public Codec getCodec(Class<?> type2) {
        return this.registeredCodec.get(type2);
    }

    public byte[] serialize(Object obj) {
        Codec codec = this.registeredCodec.get(obj.getClass());
        if (codec != null) {
            return codec.serialize(obj);
        }
        throw new SerializationException(String.format("No codec for class %s", obj.getClass().getName()));
    }

    public <T> T deserialize(byte[] bytes2, Class<T> clazz) {
        Codec codec = this.registeredCodec.get(clazz);
        if (codec != null) {
            return codec.deserialize(bytes2);
        }
        throw new DeserializationException(String.format("No codec for class %s", clazz.getClass().getName()));
    }
}

