/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.hook.request.AbstractRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class CreateRoomRequest
extends AbstractRequest {
    private static final Keyword maxMembersK = RT.keyword(null, (String)"max-members");
    private static final Keyword emptyRoomTtlK = RT.keyword(null, (String)"empty-room-ttl");
    private static final Keyword playerTtlK = RT.keyword(null, (String)"player-ttl");
    private static final Keyword expectMK = RT.keyword(null, (String)"expect-m");
    private static final Keyword isVisibleK = RT.keyword(null, (String)"visible?");
    private static final Keyword lobbyKeysK = RT.keyword(null, (String)"lobby-keys");
    private static final Keyword attrK = RT.keyword(null, (String)"attr");

    public CreateRoomRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public int getMaxPlayerCount() {
        return this.getParameter(maxMembersK, 10);
    }

    public CreateRoomRequest setMaxPlayerCount(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException();
        }
        this.setParameter(maxMembersK, max);
        return this;
    }

    public int getEmptyRoomTtlSecs() {
        return this.getParameter(emptyRoomTtlK, 0);
    }

    public CreateRoomRequest setEmptyRoomTtl(long ttl, TimeUnit unit) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException();
        }
        this.setParameter(emptyRoomTtlK, (int)unit.toSeconds(ttl));
        return this;
    }

    public int getPlayerTtlSecs() {
        return this.getParameter(playerTtlK, 0);
    }

    public CreateRoomRequest setPlayerTtl(long ttl, TimeUnit unit) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException();
        }
        this.setParameter(playerTtlK, (int)unit.toSeconds(ttl));
        return this;
    }

    public List<String> getExpectUsers() {
        return this.getParameter(expectMK, Collections.emptyList());
    }

    public CreateRoomRequest setExpectUsers(List<String> expectUsers) {
        Objects.requireNonNull(expectUsers);
        if (expectUsers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectMK, PersistentVector.create(expectUsers));
        return this;
    }

    public boolean isVisible() {
        return this.getParameter(isVisibleK, true);
    }

    public CreateRoomRequest hideRoom() {
        this.setParameter(isVisibleK, false);
        return this;
    }

    public CreateRoomRequest exposeRoom() {
        this.setParameter(isVisibleK, true);
        return this;
    }

    public List<String> getLobbyKeys() {
        return this.getParameter(lobbyKeysK, Collections.emptyList());
    }

    public CreateRoomRequest setLobbyKeys(List<String> keys) {
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(lobbyKeysK, PersistentVector.create(keys));
        return this;
    }

    public Map<String, Object> getRoomProperties() {
        return this.getParameter(attrK, Collections.emptyMap());
    }

    public CreateRoomRequest setRoomProperties(Map<String, Object> attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attrK, PersistentHashMap.create(attr));
        return this;
    }
}

