/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import cn.leancloud.play.hook.request.AbstractRequest;
import cn.leancloud.play.hook.request.RoomSystemProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class SetRoomSystemPropertiesRequest
extends AbstractRequest {
    private static final Keyword sysAttrK = RT.keyword(null, "sys-attr");
    private static final Keyword expectSysAttrK = RT.keyword(null, "expect-sys-attr");
    private static final Keyword expectMembersK = RT.keyword(null, "expectMembers");
    private static final Keyword visibleK = RT.keyword(null, "visible");
    private static final Keyword openK = RT.keyword(null, "open");

    public SetRoomSystemPropertiesRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public Optional<OpenRoomProperty> getOpenRoomProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        Boolean valueToSet = (Boolean)oldProps.get(OpenRoomProperty.propertyKey);
        HashMap<Keyword, Object> oldExpectedProps = new HashMap<Keyword, Object>(this.getExpectedValues());
        Boolean expectedValue = (Boolean)oldExpectedProps.get(OpenRoomProperty.propertyKey);
        if (expectedValue != null) {
            assert (valueToSet != null);
            return Optional.of(OpenRoomProperty.set(valueToSet, expectedValue));
        }
        if (valueToSet != null) {
            return Optional.of(OpenRoomProperty.set(valueToSet));
        }
        return Optional.empty();
    }

    public SetRoomSystemPropertiesRequest setOpenRoomProperty(OpenRoomProperty property) {
        Objects.requireNonNull(property);
        if (property.getValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(OpenRoomProperty.propertyKey, property.getValueToSet());
            this.setProperties(oldProps);
        }
        if (property.getExpectedValue() != null) {
            HashMap<Keyword, Object> oldExpectedProps = new HashMap<Keyword, Object>(this.getExpectedValues());
            oldExpectedProps.put(OpenRoomProperty.propertyKey, property.getExpectedValue());
            this.setExpectedValues(oldExpectedProps);
        }
        return this;
    }

    public Optional<ExposeRoomProperty> getExposeRoomProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        Boolean valueToSet = (Boolean)oldProps.get(ExposeRoomProperty.propertyKey);
        HashMap<Keyword, Object> oldExpectedProps = new HashMap<Keyword, Object>(this.getExpectedValues());
        Boolean expectedValue = (Boolean)oldExpectedProps.get(ExposeRoomProperty.propertyKey);
        if (expectedValue != null) {
            assert (valueToSet != null);
            return Optional.of(ExposeRoomProperty.set(valueToSet, expectedValue));
        }
        if (valueToSet != null) {
            return Optional.of(ExposeRoomProperty.set(valueToSet));
        }
        return Optional.empty();
    }

    public SetRoomSystemPropertiesRequest setExposeRoomProperty(ExposeRoomProperty property) {
        Objects.requireNonNull(property);
        if (property.getValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(ExposeRoomProperty.propertyKey, property.getValueToSet());
            this.setProperties(oldProps);
        }
        if (property.getExpectedValue() != null) {
            HashMap<Keyword, Object> oldExpectedProps = new HashMap<Keyword, Object>(this.getExpectedValues());
            oldExpectedProps.put(ExposeRoomProperty.propertyKey, property.getExpectedValue());
            this.setExpectedValues(oldExpectedProps);
        }
        return this;
    }

    public Optional<ExpectedMembersProperty> getExpectedMembersProperty() {
        HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
        List valueToSet = (List)oldProps.get(ExpectedMembersProperty.propertyKey);
        HashMap<Keyword, Object> oldExpectedProps = new HashMap<Keyword, Object>(this.getExpectedValues());
        List expectedValue = (List)oldExpectedProps.get(ExpectedMembersProperty.propertyKey);
        if (expectedValue != null) {
            assert (valueToSet != null);
            return Optional.of(ExpectedMembersProperty.set(valueToSet, expectedValue));
        }
        if (valueToSet != null) {
            return Optional.of(ExpectedMembersProperty.set(valueToSet));
        }
        return Optional.empty();
    }

    public SetRoomSystemPropertiesRequest setExpectedMembersProperty(ExpectedMembersProperty property) {
        Objects.requireNonNull(property);
        if (property.getValueToSet() != null) {
            HashMap<Keyword, Object> oldProps = new HashMap<Keyword, Object>(this.getProperties());
            oldProps.put(ExpectedMembersProperty.propertyKey, property.getValueToSet());
            this.setProperties(oldProps);
        }
        if (property.getExpectedValue() != null) {
            HashMap<Keyword, Object> oldExpectedProps = new HashMap<Keyword, Object>(this.getExpectedValues());
            oldExpectedProps.put(ExpectedMembersProperty.propertyKey, property.getExpectedValue());
            this.setExpectedValues(oldExpectedProps);
        }
        return this;
    }

    private void setProperties(Map<Keyword, Object> attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(sysAttrK, PersistentHashMap.create(attr));
    }

    private Map<Keyword, Object> getProperties() {
        return this.getParameter(sysAttrK, Collections.emptyMap());
    }

    private Map<Keyword, Object> getExpectedValues() {
        return this.getParameter(expectSysAttrK, Collections.emptyMap());
    }

    private void setExpectedValues(Map<Keyword, Object> casAttr) {
        Objects.requireNonNull(casAttr);
        if (casAttr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectSysAttrK, PersistentHashMap.create(casAttr));
    }

    static /* synthetic */ Keyword access$300() {
        return expectMembersK;
    }

    static /* synthetic */ Keyword access$400() {
        return visibleK;
    }

    static /* synthetic */ Keyword access$500() {
        return openK;
    }

    public static final class OpenRoomProperty
    implements RoomSystemProperty<Keyword, Boolean> {
        private static Keyword propertyKey = SetRoomSystemPropertiesRequest.access$500();
        private final Boolean valueToSet;
        private final Boolean expectedValue;

        private OpenRoomProperty(Boolean valueToSet, Boolean expectedValue) {
            Objects.requireNonNull(valueToSet);
            this.valueToSet = valueToSet;
            this.expectedValue = expectedValue;
        }

        public static OpenRoomProperty set(Boolean valueToSet) {
            return new OpenRoomProperty(valueToSet, null);
        }

        public static OpenRoomProperty set(Boolean valueToSet, Boolean expectedValue) {
            return new OpenRoomProperty(valueToSet, expectedValue);
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public Boolean getValueToSet() {
            return this.valueToSet;
        }

        @Override
        public Boolean getExpectedValue() {
            return this.expectedValue;
        }
    }

    public static final class ExposeRoomProperty
    implements RoomSystemProperty<Keyword, Boolean> {
        private static Keyword propertyKey = SetRoomSystemPropertiesRequest.access$400();
        private final Boolean valueToSet;
        private final Boolean expectedValue;

        private ExposeRoomProperty(Boolean valueToSet, Boolean expectedValue) {
            Objects.requireNonNull(valueToSet);
            this.valueToSet = valueToSet;
            this.expectedValue = expectedValue;
        }

        public static ExposeRoomProperty set(Boolean valueToSet) {
            return new ExposeRoomProperty(valueToSet, null);
        }

        public static ExposeRoomProperty set(Boolean valueToSet, Boolean expectedValue) {
            return new ExposeRoomProperty(valueToSet, expectedValue);
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public Boolean getValueToSet() {
            return this.valueToSet;
        }

        @Override
        public Boolean getExpectedValue() {
            return this.expectedValue;
        }
    }

    public static final class ExpectedMembersProperty
    implements RoomSystemProperty<Keyword, List<String>> {
        private static Keyword propertyKey = SetRoomSystemPropertiesRequest.access$300();
        private final List<String> valueToSet;
        private final List<String> expectedValue;

        private ExpectedMembersProperty(List<String> valueToSet, List<String> expectedValue) {
            this.valueToSet = Collections.unmodifiableList(new ArrayList<String>(valueToSet));
            this.expectedValue = expectedValue != null ? Collections.unmodifiableList(new ArrayList<String>(expectedValue)) : null;
        }

        public static ExpectedMembersProperty set(List<String> valueToSet) {
            Objects.requireNonNull(valueToSet);
            return new ExpectedMembersProperty(valueToSet, null);
        }

        public static ExpectedMembersProperty set(List<String> valueToSet, List<String> expectedValue) {
            Objects.requireNonNull(valueToSet);
            return new ExpectedMembersProperty(valueToSet, expectedValue);
        }

        @Override
        public Keyword getPropertyKey() {
            return propertyKey;
        }

        @Override
        public List<String> getValueToSet() {
            return this.valueToSet;
        }

        @Override
        public List<String> getExpectedValue() {
            return this.expectedValue;
        }
    }
}

