/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.hook.request.AbstractRequest;
import cn.leancloud.play.hook.request.CacheOption;
import cn.leancloud.play.hook.request.ReceiverGroup;
import cn.leancloud.play.utils.Log;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RaiseRpcRequest
extends AbstractRequest {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Keyword cacheOptionK = RT.keyword(null, (String)"cache-option");
    private static final Keyword receiverGroupK = RT.keyword(null, (String)"receiver-group");
    private static final Keyword toActorsK = RT.keyword(null, (String)"to-actors");
    private static final Keyword binK = RT.keyword(null, (String)"bin");
    private static final Keyword dataK = RT.keyword(null, (String)"data");
    private static final Keyword eventIdK = RT.keyword(null, (String)"event-id");
    private static final Keyword fromActorIdK = RT.keyword(null, (String)"from-actor-id");

    public RaiseRpcRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public CacheOption getCacheOption() {
        Number opt = (Number)this.getParameter(cacheOptionK);
        if (opt != null) {
            return CacheOption.of(opt.byteValue());
        }
        return CacheOption.NO_CACHE;
    }

    public RaiseRpcRequest setCacheOption(CacheOption opt) {
        Objects.requireNonNull(opt);
        this.setParameter(cacheOptionK, opt.getCode());
        return this;
    }

    public ReceiverGroup getReceiverGroup() {
        Number gp = (Number)this.getParameter(receiverGroupK);
        if (gp != null) {
            return ReceiverGroup.of(gp.byteValue());
        }
        return ReceiverGroup.OTHERS;
    }

    public RaiseRpcRequest setReceiverGroup(ReceiverGroup group) {
        Objects.requireNonNull(group);
        this.setParameter(receiverGroupK, group.getCode());
        return this;
    }

    public List<Integer> getToActorIds() {
        List actors = (List)this.getParameter(toActorsK);
        if (actors != null) {
            return actors.stream().map(Number::intValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public RaiseRpcRequest setToActorIds(List<Integer> actorIds) {
        Objects.requireNonNull(actorIds);
        this.setParameter(toActorsK, PersistentVector.create(actorIds));
        return this;
    }

    public byte[] getData() {
        Boolean isBin = (Boolean)this.getParameter(binK);
        Object data = this.getParameter(dataK);
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        if (isBin != null && isBin.booleanValue()) {
            return (byte[])data;
        }
        return ((String)data).getBytes(StandardCharsets.UTF_8);
    }

    public RaiseRpcRequest setData(byte[] data) {
        Boolean isBin = (Boolean)this.getParameter(binK);
        if (isBin != null && isBin.booleanValue()) {
            this.setParameter(dataK, data);
        } else {
            this.setParameter(dataK, new String(data, StandardCharsets.UTF_8));
        }
        return this;
    }

    public int getEventId() {
        Number id = (Number)this.getParameter(eventIdK);
        if (id != null) {
            return id.intValue();
        }
        return -1;
    }

    public int getFromActorId() {
        Number id = (Number)this.getParameter(fromActorIdK);
        if (id != null) {
            return id.intValue();
        }
        Log.error("No from actor id in {}. current params={}", (Object)RaiseRpcRequest.class.getSimpleName(), this.getAllParameters());
        return -1;
    }
}

