/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.request;

import cn.leancloud.play.Builder;
import cn.leancloud.play.hook.request.CacheOption;
import java.util.Objects;

public final class RaiseRpcOptions {
    private final int eventId;
    private final CacheOption cacheOption;

    private RaiseRpcOptions(RaiseRpcOptionsBuilder builder) {
        this.eventId = builder.eventId;
        this.cacheOption = builder.cacheOption;
    }

    public int getEventId() {
        return this.eventId;
    }

    public CacheOption getCacheOption() {
        return this.cacheOption;
    }

    public static class RaiseRpcOptionsBuilder
    implements Builder<RaiseRpcOptions> {
        private int eventId = -1;
        private CacheOption cacheOption;

        public RaiseRpcOptionsBuilder withEventId(int eventId) {
            if (eventId < 0) {
                throw new IllegalArgumentException();
            }
            this.eventId = eventId;
            return this;
        }

        public RaiseRpcOptionsBuilder withCacheOption(CacheOption option) {
            this.cacheOption = Objects.requireNonNull(option);
            return this;
        }

        @Override
        public RaiseRpcOptions build() {
            return new RaiseRpcOptions(this);
        }
    }
}

