/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.context;

import cn.leancloud.play.hook.HookResponse;
import cn.leancloud.play.hook.HookedRoom;
import cn.leancloud.play.hook.Reason;
import cn.leancloud.play.hook.context.Context;
import cn.leancloud.play.hook.context.ContextStatus;
import cn.leancloud.play.hook.request.RoomRequest;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class AbstractOperationContext<T extends RoomRequest>
implements Context<T> {
    private final CompletableFuture<HookResponse<T>> future;
    private final T req;
    private final HookedRoom hookedRoom;
    private ContextStatus status;

    AbstractOperationContext(T req, HookedRoom hookedRoom, CompletableFuture<HookResponse<T>> future) {
        Objects.requireNonNull(req);
        Objects.requireNonNull(future);
        this.req = req;
        this.future = future;
        this.status = ContextStatus.NEW;
        this.hookedRoom = hookedRoom;
    }

    @Override
    public ContextStatus getStatus() {
        return this.status;
    }

    @Override
    public T getRequest() {
        return this.req;
    }

    @Override
    public HookedRoom getHookedRoom() {
        return this.hookedRoom;
    }

    @Override
    public void continueProcess() {
        this.updateStatusWhenNotProcessed(ContextStatus.CONTINUED);
        this.completeHookFuture(HookResponse.success(this.req));
    }

    @Override
    public void rejectProcess(Reason reason) {
        this.updateStatusWhenNotProcessed(ContextStatus.REJECTED);
        this.completeHookFuture(HookResponse.reject(reason));
    }

    void updateStatusWhenNotProcessed(ContextStatus newStatus) {
        if (this.status != ContextStatus.NEW && this.status != ContextStatus.DEFERRED) {
            throw new IllegalStateException("request already processed");
        }
        this.status = newStatus;
    }

    void completeHookFuture(HookResponse<T> response) {
        this.req.setReadOnly();
        this.future.complete(response);
    }
}

