/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.hook.request.AbstractRequest;
import cn.leancloud.play.hook.request.CacheOption;
import cn.leancloud.play.hook.request.ReceiverGroup;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RaiseRpcRequest
extends AbstractRequest {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Keyword cache_option_k = RT.keyword(null, (String)"cache-option");
    private static final Keyword receiver_group_k = RT.keyword(null, (String)"receiver-group");
    private static final Keyword to_actors_k = RT.keyword(null, (String)"to-actors");
    private static final Keyword bin_k = RT.keyword(null, (String)"bin");
    private static final Keyword data_k = RT.keyword(null, (String)"data");
    private static final Keyword event_id_k = RT.keyword(null, (String)"event-id");
    private static final Keyword from_actor_id_k = RT.keyword(null, (String)"from-actor-id");

    public RaiseRpcRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public CacheOption getCacheOption() {
        Number opt = (Number)this.getParameter(cache_option_k);
        if (opt != null) {
            return CacheOption.of(opt.byteValue());
        }
        return CacheOption.NO_CACHE;
    }

    public RaiseRpcRequest setCacheOption(CacheOption opt) {
        Objects.requireNonNull(opt);
        this.setParameter(cache_option_k, opt.getCode());
        return this;
    }

    public ReceiverGroup getReceiverGroup() {
        Number gp = (Number)this.getParameter(receiver_group_k);
        if (gp != null) {
            return ReceiverGroup.of(gp.byteValue());
        }
        return ReceiverGroup.OTHERS;
    }

    public RaiseRpcRequest setReceiverGroup(ReceiverGroup group) {
        Objects.requireNonNull(group);
        this.setParameter(receiver_group_k, group.getCode());
        return this;
    }

    public List<Integer> getToActorIds() {
        List actors = (List)this.getParameter(to_actors_k);
        if (actors != null) {
            return actors.stream().map(Number::intValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public RaiseRpcRequest setToActorIds(List<Integer> actorIds) {
        Objects.requireNonNull(actorIds);
        this.setParameter(to_actors_k, PersistentVector.create(actorIds));
        return this;
    }

    public byte[] getData() {
        Boolean isBin = (Boolean)this.getParameter(bin_k);
        Object data = this.getParameter(data_k);
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        if (isBin != null && isBin.booleanValue()) {
            return (byte[])data;
        }
        return ((String)data).getBytes(StandardCharsets.UTF_8);
    }

    public RaiseRpcRequest setData(byte[] data) {
        Boolean isBin = (Boolean)this.getParameter(bin_k);
        if (isBin != null && isBin.booleanValue()) {
            this.setParameter(data_k, data);
        } else {
            this.setParameter(data_k, new String(data, StandardCharsets.UTF_8));
        }
        return this;
    }

    public int getEventId() {
        Number id = (Number)this.getParameter(event_id_k);
        if (id != null) {
            return id.intValue();
        }
        return -1;
    }

    public int getFromActorId() {
        Number id = (Number)this.getParameter(from_actor_id_k);
        if (id != null) {
            return id.intValue();
        }
        return -1;
    }
}

