/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.hook.request.AbstractRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class CreateRoomRequest
extends AbstractRequest {
    private static final Keyword max_members_k = RT.keyword(null, (String)"max-members");
    private static final Keyword empty_room_ttl_k = RT.keyword(null, (String)"empty-room-ttl");
    private static final Keyword player_ttl_k = RT.keyword(null, (String)"player-ttl");
    private static final Keyword expect_m_k = RT.keyword(null, (String)"expect-m");
    private static final Keyword is_visible_k = RT.keyword(null, (String)"visible?");
    private static final Keyword lobby_keys_k = RT.keyword(null, (String)"lobby-keys");
    private static final Keyword attr_k = RT.keyword(null, (String)"attr");

    public CreateRoomRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public int getMaxPlayerCount() {
        return this.getParameter(max_members_k, 10);
    }

    public CreateRoomRequest setMaxPlayerCount(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException();
        }
        this.setParameter(max_members_k, max);
        return this;
    }

    public int getEmptyRoomTtlSecs() {
        return this.getParameter(empty_room_ttl_k, 0);
    }

    public CreateRoomRequest setEmptyRoomTtl(long ttl, TimeUnit unit) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException();
        }
        this.setParameter(empty_room_ttl_k, (int)unit.toSeconds(ttl));
        return this;
    }

    public int getPlayerTtlSecs() {
        return this.getParameter(player_ttl_k, 0);
    }

    public CreateRoomRequest setPlayerTtl(long ttl, TimeUnit unit) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException();
        }
        this.setParameter(player_ttl_k, (int)unit.toSeconds(ttl));
        return this;
    }

    public List<String> getExpectUsers() {
        return this.getParameter(expect_m_k, Collections.emptyList());
    }

    public CreateRoomRequest setExpectUsers(List<String> expectUsers) {
        Objects.requireNonNull(expectUsers);
        if (expectUsers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expect_m_k, PersistentVector.create(expectUsers));
        return this;
    }

    public boolean isVisible() {
        return this.getParameter(is_visible_k, true);
    }

    public CreateRoomRequest hideRoom() {
        this.setParameter(is_visible_k, false);
        return this;
    }

    public CreateRoomRequest exposeRoom() {
        this.setParameter(is_visible_k, true);
        return this;
    }

    public List<String> getLobbyKeys() {
        return this.getParameter(lobby_keys_k, Collections.emptyList());
    }

    public CreateRoomRequest setLobbyKeys(List<String> keys) {
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(lobby_keys_k, PersistentVector.create(keys));
        return this;
    }

    public Map<String, Object> getRoomProperties() {
        return this.getParameter(attr_k, Collections.emptyMap());
    }

    public CreateRoomRequest setRoomProperties(Map<String, Object> attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attr_k, PersistentHashMap.create(attr));
        return this;
    }
}

