/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook.context;

import cn.leancloud.play.hook.HookResponse;
import cn.leancloud.play.hook.Reason;
import cn.leancloud.play.hook.context.ContextStatus;
import cn.leancloud.play.hook.request.AbstractRequest;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class AbstractOperationContext<T extends AbstractRequest> {
    private final CompletableFuture<HookResponse<T>> future;
    private final T req;
    private ContextStatus status;

    AbstractOperationContext(T req, CompletableFuture<HookResponse<T>> future2) {
        Objects.requireNonNull(req);
        Objects.requireNonNull(future2);
        this.req = req;
        this.future = future2;
        this.status = ContextStatus.NEW;
    }

    public ContextStatus getStatus() {
        return this.status;
    }

    public T getRequest() {
        return this.req;
    }

    public abstract String getHookName();

    public void continueProcess() {
        this.updateStatusWhenNotProcessed(ContextStatus.CONTINUED);
        this.completeHookFuture(HookResponse.success(this.req));
    }

    public void rejectProcess(Reason reason) {
        this.updateStatusWhenNotProcessed(ContextStatus.REJECTED);
        this.completeHookFuture(HookResponse.reject(reason));
    }

    void updateStatusWhenNotProcessed(ContextStatus newStatus) {
        if (this.status != ContextStatus.NEW && this.status != ContextStatus.DEFERRED) {
            throw new IllegalStateException("request already processed");
        }
        this.status = newStatus;
    }

    void completeHookFuture(HookResponse<T> response) {
        ((AbstractRequest)this.req).setReadOnly();
        this.future.complete(response);
    }
}

