/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.hook;

public final class Reason {
    public static final Reason EMPTY_REASON = new Reason();
    private final int appCode;
    private final String msg;

    private Reason() {
        this.appCode = -1;
        this.msg = "";
    }

    private Reason(int appCode) {
        if (appCode < 0) {
            throw new IllegalArgumentException("appCode should be a non-negative integer");
        }
        this.appCode = appCode;
        this.msg = "";
    }

    private Reason(int appCode, String msg) {
        if (appCode < 0) {
            throw new IllegalArgumentException("appCode should be a non-negative integer");
        }
        if (msg != null && msg.length() > 512) {
            throw new IllegalArgumentException("msg should shorter than 512 characters");
        }
        this.appCode = appCode;
        this.msg = msg == null ? "" : msg;
    }

    public static Reason of(int appCode) {
        return new Reason(appCode);
    }

    public static Reason of(int appCode, String message) {
        return new Reason(appCode, message);
    }

    public int getAppCode() {
        return this.appCode;
    }

    public String getMessage() {
        return this.msg;
    }

    public String toString() {
        return "cn.leancloud.play.hook.Reason{appCode=" + this.appCode + ", message='" + this.msg + '\'' + '}';
    }
}

