/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.utils;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoggerInit {
    public static final String LOG_NAME_CONFIG_DATA = "DiamondConfigDataLog";
    public static final Log log = LogFactory.getLog(LoggerInit.class);
    private static volatile boolean initOK = false;
    private static Properties defaultProperties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogFromBizLog() {
        if (initOK) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(LoggerInit.class.getClassLoader());
        try {
            PropertyConfigurator.configure((Properties)defaultProperties);
            FileAppender bizFileAppender = LoggerInit.getFileAppender(Logger.getRootLogger());
            if (null == bizFileAppender) {
                log.warn((Object)"\u4e0a\u5c42\u4e1a\u52a1\u5c42\u6ca1\u6709\u5728ROOT LOGGER\u4e0a\u8bbe\u7f6eFileAppender!!!");
                bizFileAppender = new FileAppender();
                bizFileAppender.setFile(System.getProperty("user.home") + "/diamond/logs/diamond_config_data.log");
            }
            LoggerInit.setFileAppender(bizFileAppender, LOG_NAME_CONFIG_DATA);
            initOK = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static void setFileAppender(FileAppender bizFileAppender, String logName) {
        FileAppender fileAppender = LoggerInit.getFileAppender(Logger.getLogger((String)logName));
        String bizLogDir = new File(bizFileAppender.getFile()).getParent();
        File newLogFile = new File(bizLogDir, fileAppender.getFile());
        fileAppender.setFile(newLogFile.getAbsolutePath());
        fileAppender.activateOptions();
        log.warn((Object)("\u6210\u529f\u4e3a" + logName + "\u6dfb\u52a0Appender. \u8f93\u51fa\u8def\u5f84:" + newLogFile.getAbsolutePath()));
    }

    private static FileAppender getFileAppender(Logger logger) {
        FileAppender fileAppender = null;
        Enumeration appenders = logger.getAllAppenders();
        while (null == fileAppender && appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!FileAppender.class.isInstance(appender)) continue;
            fileAppender = (FileAppender)appender;
        }
        return fileAppender;
    }

    static {
        defaultProperties.put("log4j.logger.DiamondConfigDataLog", "info, DiamondConfigDataLogFile");
        defaultProperties.put("log4j.additivity.DiamondConfigDataLog", "false");
        defaultProperties.put("log4j.appender.DiamondConfigDataLogFile", "org.apache.log4j.DailyRollingFileAppender");
        defaultProperties.put("log4j.appender.DiamondConfigDataLogFile.DatePattern", "'.'yyyy-MM-dd");
        defaultProperties.put("log4j.appender.DiamondConfigDataLogFile.File", "diamond_config_data.log");
        defaultProperties.put("log4j.appender.DiamondConfigDataLogFile.layout", "org.apache.log4j.PatternLayout");
        defaultProperties.put("log4j.appender.DiamondConfigDataLogFile.layout.ConversionPattern", "%d{MM-dd HH:mm:ss} - %m%n");
        defaultProperties.put("log4j.appender.DiamondConfigDataLogFile.Append", "true");
    }
}

