/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.client.processor;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;

public class SnapshotConfigInfoProcessor {
    private final String dir;

    public SnapshotConfigInfoProcessor(String dir) {
        this.dir = dir;
        File file = new File(this.dir);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigInfomation(String dataId, String group) throws IOException {
        if (StringUtils.isBlank((String)dataId)) {
            return null;
        }
        if (StringUtils.isBlank((String)group)) {
            return null;
        }
        String path = this.dir + File.separator + group;
        File dir = new File(path);
        if (!dir.exists()) {
            return null;
        }
        String filePath = path + File.separator + dataId;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = null;
        StringBuilder sb = new StringBuilder(512);
        try {
            in = new FileInputStream(file);
            byte[] data = new byte[8192];
            int n = -1;
            while ((n = in.read(data)) != -1) {
                sb.append(new String(data, 0, n, "UTF-8"));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSnaptshot(String dataId, String group, String config) throws IOException {
        if (StringUtils.isBlank((String)dataId)) {
            throw new IllegalArgumentException("blank dataId");
        }
        if (StringUtils.isBlank((String)group)) {
            throw new IllegalArgumentException("blank group");
        }
        if (config == null) {
            config = "";
        }
        File file = this.getTargetFile(dataId, group);
        FileOutputStream out = null;
        PrintWriter writer = null;
        try {
            out = new FileOutputStream(file);
            BufferedOutputStream stream = new BufferedOutputStream(out);
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8")));
            writer.write(config);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public void removeSnapshot(String dataId, String group) {
        if (StringUtils.isBlank((String)dataId)) {
            return;
        }
        if (StringUtils.isBlank((String)group)) {
            return;
        }
        String path = this.dir + File.separator + group;
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        String filePath = path + File.separator + dataId;
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        file.delete();
        String[] list = dir.list();
        if (list == null || list.length == 0) {
            dir.delete();
        }
    }

    private File getTargetFile(String dataId, String group) throws IOException {
        String path = this.dir + File.separator + group;
        this.createDirIfNessary(path);
        String filePath = path + File.separator + dataId;
        File file = this.createFileIfNessary(filePath);
        return file;
    }

    private void createDirIfNessary(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private File createFileIfNessary(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }
}

