/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.manager.impl;

import cn.leancloud.diamond.client.DiamondConfigure;
import cn.leancloud.diamond.client.DiamondSubscriber;
import cn.leancloud.diamond.client.impl.DefaultSubscriberListener;
import cn.leancloud.diamond.client.impl.DiamondClientFactory;
import cn.leancloud.diamond.manager.DiamondManager;
import cn.leancloud.diamond.manager.ManagerListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiamondManager
implements DiamondManager {
    private static final Log log = LogFactory.getLog(DefaultDiamondManager.class);
    private DiamondSubscriber diamondSubscriber = null;
    private final List<ManagerListener> managerListeners = new LinkedList<ManagerListener>();
    private final String dataId;
    private final String group;

    public DefaultDiamondManager(String dataId, ManagerListener managerListener) {
        this(null, dataId, managerListener);
    }

    public DefaultDiamondManager(String group, String dataId, ManagerListener managerListener) {
        this.dataId = dataId;
        this.group = group;
        this.diamondSubscriber = DiamondClientFactory.getSingletonDiamondSubscriber();
        this.managerListeners.add(managerListener);
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).addManagerListeners(this.dataId, this.group, this.managerListeners);
        this.diamondSubscriber.addDataId(this.dataId, this.group);
        this.diamondSubscriber.start();
    }

    public DefaultDiamondManager(String dataId, List<ManagerListener> managerListenerList) {
        this(null, dataId, managerListenerList);
    }

    public DefaultDiamondManager(String group, String dataId, List<ManagerListener> managerListenerList) {
        this.dataId = dataId;
        this.group = group;
        this.diamondSubscriber = DiamondClientFactory.getSingletonDiamondSubscriber();
        this.managerListeners.addAll(managerListenerList);
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).addManagerListeners(this.dataId, this.group, this.managerListeners);
        this.diamondSubscriber.addDataId(this.dataId, this.group);
        this.diamondSubscriber.start();
    }

    @Override
    public void setManagerListener(ManagerListener managerListener) {
        this.managerListeners.clear();
        this.managerListeners.add(managerListener);
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).removeManagerListeners(this.dataId, this.group);
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).addManagerListeners(this.dataId, this.group, this.managerListeners);
    }

    @Override
    public void close() {
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).removeManagerListeners(this.dataId, this.group);
        this.diamondSubscriber.removeDataId(this.dataId, this.group);
        if (this.diamondSubscriber.getDataIds().size() == 0) {
            this.diamondSubscriber.close();
        }
    }

    @Override
    public String getConfigureInfomation(long timeout) {
        return this.diamondSubscriber.getConfigureInfomation(this.dataId, this.group, timeout);
    }

    @Override
    public String getAvailableConfigureInfomation(long timeout) {
        return this.diamondSubscriber.getAvailableConfigureInfomation(this.dataId, this.group, timeout);
    }

    @Override
    public String getAvailableConfigureInfomationFromSnapshot(long timeout) {
        return this.diamondSubscriber.getAvailableConfigureInfomationFromSnapshot(this.dataId, this.group, timeout);
    }

    @Override
    public Properties getAvailablePropertiesConfigureInfomation(long timeout) {
        String configInfo = this.getAvailableConfigureInfomation(timeout);
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(configInfo));
            return properties;
        }
        catch (IOException e) {
            log.warn((Object)("\u88c5\u8f7dproperties\u5931\u8d25\uff1a" + configInfo), (Throwable)e);
            throw new RuntimeException("\u88c5\u8f7dproperties\u5931\u8d25\uff1a" + configInfo, e);
        }
    }

    @Override
    public Properties getAvailablePropertiesConfigureInfomationFromSnapshot(long timeout) {
        String configInfo = this.getAvailableConfigureInfomationFromSnapshot(timeout);
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(configInfo));
            return properties;
        }
        catch (IOException e) {
            log.warn((Object)("\u88c5\u8f7dproperties\u5931\u8d25\uff1a" + configInfo), (Throwable)e);
            throw new RuntimeException("\u88c5\u8f7dproperties\u5931\u8d25\uff1a" + configInfo, e);
        }
    }

    @Override
    public void setManagerListeners(List<ManagerListener> managerListenerList) {
        this.managerListeners.clear();
        this.managerListeners.addAll(managerListenerList);
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).removeManagerListeners(this.dataId, this.group);
        ((DefaultSubscriberListener)this.diamondSubscriber.getSubscriberListener()).addManagerListeners(this.dataId, this.group, this.managerListeners);
    }

    @Override
    public DiamondConfigure getDiamondConfigure() {
        return this.diamondSubscriber.getDiamondConfigure();
    }

    @Override
    public void setDiamondConfigure(DiamondConfigure diamondConfigure) {
        this.diamondSubscriber.setDiamondConfigure(diamondConfigure);
    }

    @Override
    public Properties getPropertiesConfigureInfomation(long timeout) {
        String configInfo = this.getConfigureInfomation(timeout);
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(configInfo));
            return properties;
        }
        catch (IOException e) {
            log.warn((Object)("\u88c5\u8f7dproperties\u5931\u8d25\uff1a" + configInfo), (Throwable)e);
            throw new RuntimeException("\u88c5\u8f7dproperties\u5931\u8d25\uff1a" + configInfo, e);
        }
    }

    @Override
    public List<ManagerListener> getManagerListeners() {
        return this.managerListeners;
    }
}

