/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.client.impl;

import cn.leancloud.diamond.client.DiamondConfigure;
import cn.leancloud.diamond.client.DiamondSubscriber;
import cn.leancloud.diamond.client.SubscriberListener;
import cn.leancloud.diamond.client.processor.LocalConfigInfoProcessor;
import cn.leancloud.diamond.client.processor.ServerAddressProcessor;
import cn.leancloud.diamond.client.processor.SnapshotConfigInfoProcessor;
import cn.leancloud.diamond.common.Constants;
import cn.leancloud.diamond.configinfo.CacheData;
import cn.leancloud.diamond.configinfo.ConfigureInfomation;
import cn.leancloud.diamond.md5.MD5;
import cn.leancloud.diamond.mockserver.MockServer;
import cn.leancloud.diamond.utils.LoggerInit;
import cn.leancloud.diamond.utils.SimpleCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultDiamondSubscriber
implements DiamondSubscriber {
    private static final String DATA_DIR = "data";
    private static final String SNAPSHOT_DIR = "snapshot";
    private static final Log log = LogFactory.getLog(DefaultDiamondSubscriber.class);
    private static final int SC_OK = 200;
    private static final int SC_NOT_MODIFIED = 304;
    private static final int SC_NOT_FOUND = 404;
    private static final int SC_SERVICE_UNAVAILABLE = 503;
    private final Log dataLog = LogFactory.getLog((String)"DiamondConfigDataLog");
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, CacheData>> cache = new ConcurrentHashMap();
    private volatile SubscriberListener subscriberListener = null;
    private volatile DiamondConfigure diamondConfigure;
    private ScheduledExecutorService scheduledExecutor = null;
    private final LocalConfigInfoProcessor localConfigInfoProcessor = new LocalConfigInfoProcessor();
    private SnapshotConfigInfoProcessor snapshotConfigInfoProcessor;
    private final SimpleCache<String> contentCache = new SimpleCache();
    private ServerAddressProcessor serverAddressProcessor = null;
    private final AtomicInteger domainNamePos = new AtomicInteger(0);
    private volatile boolean isRun = false;
    private HttpClient httpClient = null;
    private volatile boolean bFirstCheck = true;

    public DefaultDiamondSubscriber(SubscriberListener subscriberListener) {
        this.subscriberListener = subscriberListener;
        this.diamondConfigure = new DiamondConfigure();
    }

    @Override
    public synchronized void start() {
        if (this.isRun) {
            return;
        }
        if (null == this.scheduledExecutor || this.scheduledExecutor.isTerminated()) {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.localConfigInfoProcessor.start(this.diamondConfigure.getFilePath() + "/" + DATA_DIR);
        this.serverAddressProcessor = new ServerAddressProcessor(this.diamondConfigure, this.scheduledExecutor);
        this.serverAddressProcessor.start();
        this.snapshotConfigInfoProcessor = new SnapshotConfigInfoProcessor(this.diamondConfigure.getFilePath() + "/" + SNAPSHOT_DIR);
        this.randomDomainNamePos();
        this.initHttpClient();
        this.isRun = true;
        if (log.isInfoEnabled()) {
            log.info((Object)("\u5f53\u524d\u4f7f\u7528\u7684\u57df\u540d\u6709\uff1a" + this.diamondConfigure.getDomainNameList()));
        }
        if (MockServer.isTestMode()) {
            this.bFirstCheck = false;
        } else {
            this.diamondConfigure.setPollingIntervalTime(15);
        }
        this.rotateCheckConfigInfo();
        this.addShutdownHook();
    }

    private void randomDomainNamePos() {
        Random rand = new Random();
        List<String> domainList = this.diamondConfigure.getDomainNameList();
        if (!domainList.isEmpty()) {
            this.domainNamePos.set(rand.nextInt(domainList.size()));
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DefaultDiamondSubscriber.this.close();
            }
        });
    }

    protected void initHttpClient() {
        if (MockServer.isTestMode()) {
            return;
        }
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(this.diamondConfigure.getDomainNameList().get(this.domainNamePos.get()), this.diamondConfigure.getPort());
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.closeIdleConnections((long)(this.diamondConfigure.getPollingIntervalTime() * 4000));
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setStaleCheckingEnabled(this.diamondConfigure.isConnectionStaleCheckingEnabled());
        params.setMaxConnectionsPerHost(hostConfiguration, this.diamondConfigure.getMaxHostConnections());
        params.setMaxTotalConnections(this.diamondConfigure.getMaxTotalConnections());
        params.setConnectionTimeout(this.diamondConfigure.getConnectionTimeout());
        params.setSoTimeout(60000);
        connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    void setDomainNamesPos(int pos) {
        this.domainNamePos.set(pos);
    }

    private void rotateCheckConfigInfo() {
        this.scheduledExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!DefaultDiamondSubscriber.this.isRun) {
                    log.warn((Object)"DiamondSubscriber\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\u4e2d\uff0c\u9000\u51fa\u67e5\u8be2\u5faa\u73af");
                    return;
                }
                try {
                    DefaultDiamondSubscriber.this.checkLocalConfigInfo();
                    DefaultDiamondSubscriber.this.checkDiamondServerConfigInfo();
                    DefaultDiamondSubscriber.this.checkSnapshot();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error((Object)"\u5faa\u73af\u63a2\u6d4b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    DefaultDiamondSubscriber.this.rotateCheckConfigInfo();
                }
            }
        }, this.bFirstCheck ? 60L : (long)this.diamondConfigure.getPollingIntervalTime(), TimeUnit.SECONDS);
        this.bFirstCheck = false;
    }

    private void receiveConfigInfo(final CacheData cacheData) {
        this.scheduledExecutor.execute(new Runnable(){

            public void run() {
                if (!DefaultDiamondSubscriber.this.isRun) {
                    log.warn((Object)"DiamondSubscriber\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\u4e2d\uff0c\u9000\u51fa\u67e5\u8be2\u5faa\u73af");
                    return;
                }
                try {
                    String configInfo = DefaultDiamondSubscriber.this.getConfigureInfomation(cacheData.getDataId(), cacheData.getGroup(), DefaultDiamondSubscriber.this.diamondConfigure.getReceiveWaitTime(), true);
                    if (null == configInfo) {
                        return;
                    }
                    if (null == DefaultDiamondSubscriber.this.subscriberListener) {
                        log.warn((Object)"null == subscriberListener");
                        return;
                    }
                    DefaultDiamondSubscriber.this.popConfigInfo(cacheData, configInfo);
                }
                catch (Exception e) {
                    log.error((Object)"\u5411Diamond\u670d\u52a1\u5668\u7d22\u8981\u914d\u7f6e\u4fe1\u606f\u7684\u8fc7\u7a0b\u629b\u5f02\u5e38", (Throwable)e);
                }
            }
        });
    }

    private void checkSnapshot() {
        for (Map.Entry<String, ConcurrentHashMap<String, CacheData>> cacheDatasEntry : this.cache.entrySet()) {
            ConcurrentHashMap<String, CacheData> cacheDatas = cacheDatasEntry.getValue();
            if (null == cacheDatas) continue;
            for (Map.Entry<String, CacheData> cacheDataEntry : cacheDatas.entrySet()) {
                String configInfo;
                CacheData cacheData = cacheDataEntry.getValue();
                if (cacheData.isUseLocalConfigInfo() || cacheData.getFetchCount() != 0L || (configInfo = this.getSnapshotConfiginfomation(cacheData.getDataId(), cacheData.getGroup())) == null) continue;
                this.popConfigInfo(cacheData, configInfo);
            }
        }
    }

    private void checkDiamondServerConfigInfo() {
        Set<String> updateDataIdGroupPairs = this.checkUpdateDataIds(this.diamondConfigure.getReceiveWaitTime());
        if (null == updateDataIdGroupPairs || updateDataIdGroupPairs.size() == 0) {
            log.debug((Object)"\u6ca1\u6709\u88ab\u4fee\u6539\u7684DataID");
            return;
        }
        for (String freshDataIdGroupPair : updateDataIdGroupPairs) {
            CacheData cacheData;
            int middleIndex = freshDataIdGroupPair.indexOf(Constants.WORD_SEPARATOR);
            if (middleIndex == -1) continue;
            String freshDataId = freshDataIdGroupPair.substring(0, middleIndex);
            String freshGroup = freshDataIdGroupPair.substring(middleIndex + 1);
            ConcurrentHashMap<String, CacheData> cacheDatas = this.cache.get(freshDataId);
            if (null == cacheDatas || null == (cacheData = cacheDatas.get(freshGroup))) continue;
            this.receiveConfigInfo(cacheData);
        }
    }

    private void checkLocalConfigInfo() {
        for (Map.Entry<String, ConcurrentHashMap<String, CacheData>> cacheDatasEntry : this.cache.entrySet()) {
            ConcurrentHashMap<String, CacheData> cacheDatas = cacheDatasEntry.getValue();
            if (null == cacheDatas) continue;
            for (Map.Entry<String, CacheData> cacheDataEntry : cacheDatas.entrySet()) {
                CacheData cacheData = cacheDataEntry.getValue();
                try {
                    String configInfo = this.getLocalConfigureInfomation(cacheData);
                    if (null != configInfo) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("\u672c\u5730\u914d\u7f6e\u4fe1\u606f\u88ab\u8bfb\u53d6, dataId:" + cacheData.getDataId() + ", group:" + cacheData.getGroup()));
                        }
                        this.popConfigInfo(cacheData, configInfo);
                        continue;
                    }
                    if (!cacheData.isUseLocalConfigInfo()) continue;
                }
                catch (Exception e) {
                    log.error((Object)"\u5411\u672c\u5730\u7d22\u8981\u914d\u7f6e\u4fe1\u606f\u7684\u8fc7\u7a0b\u629b\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    void popConfigInfo(CacheData cacheData, final String configInfo) {
        final ConfigureInfomation configureInfomation = new ConfigureInfomation();
        configureInfomation.setConfigureInfomation(configInfo);
        final String dataId = cacheData.getDataId();
        final String group = cacheData.getGroup();
        configureInfomation.setDataId(dataId);
        configureInfomation.setGroup(group);
        cacheData.incrementFetchCountAndGet();
        if (null != this.subscriberListener.getExecutor()) {
            this.subscriberListener.getExecutor().execute(new Runnable(){

                public void run() {
                    try {
                        DefaultDiamondSubscriber.this.subscriberListener.receiveConfigInfo(configureInfomation);
                        DefaultDiamondSubscriber.this.saveSnapshot(dataId, group, configInfo);
                    }
                    catch (Throwable t) {
                        log.error((Object)("\u914d\u7f6e\u4fe1\u606f\u76d1\u542c\u5668\u4e2d\u6709\u5f02\u5e38\uff0cgroup\u4e3a\uff1a" + group + ", dataId\u4e3a\uff1a" + dataId), t);
                    }
                }
            });
        } else {
            try {
                this.subscriberListener.receiveConfigInfo(configureInfomation);
                this.saveSnapshot(dataId, group, configInfo);
            }
            catch (Throwable t) {
                log.error((Object)("\u914d\u7f6e\u4fe1\u606f\u76d1\u542c\u5668\u4e2d\u6709\u5f02\u5e38\uff0cgroup\u4e3a\uff1a" + group + ", dataId\u4e3a\uff1a" + dataId), t);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isRun) {
            return;
        }
        log.warn((Object)"\u5f00\u59cb\u5173\u95edDiamondSubscriber");
        this.localConfigInfoProcessor.stop();
        this.serverAddressProcessor.stop();
        this.isRun = false;
        this.scheduledExecutor.shutdown();
        this.cache.clear();
        log.warn((Object)"\u5173\u95edDiamondSubscriber\u5b8c\u6210");
    }

    long getOnceTimeOut(long waitTime, long timeout) {
        long remainTime;
        long onceTimeOut = this.diamondConfigure.getOnceTimeout();
        if (onceTimeOut > (remainTime = timeout - waitTime)) {
            onceTimeOut = remainTime;
        }
        return onceTimeOut;
    }

    public String getLocalConfigureInfomation(CacheData cacheData) throws IOException {
        if (!this.isRun) {
            throw new RuntimeException("DiamondSubscriber\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\u4e2d\uff0c\u65e0\u6cd5\u83b7\u53d6\u672c\u5730ConfigureInfomation");
        }
        return this.localConfigInfoProcessor.getLocalConfigureInfomation(cacheData, false);
    }

    @Override
    public String getConfigureInfomation(String dataId, long timeout) {
        return this.getConfigureInfomation(dataId, null, timeout);
    }

    @Override
    public String getConfigureInfomation(String dataId, String group, long timeout) {
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        CacheData cacheData = this.getCacheData(dataId, group);
        try {
            String localConfig = this.localConfigInfoProcessor.getLocalConfigureInfomation(cacheData, true);
            if (localConfig != null) {
                cacheData.incrementFetchCountAndGet();
                this.saveSnapshot(dataId, group, localConfig);
                return localConfig;
            }
        }
        catch (IOException e) {
            log.error((Object)"\u83b7\u53d6\u672c\u5730\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        String result = this.getConfigureInfomation(dataId, group, timeout, false);
        if (result != null) {
            this.saveSnapshot(dataId, group, result);
            cacheData.incrementFetchCountAndGet();
        }
        return result;
    }

    private void saveSnapshot(String dataId, String group, String config) {
        if (config != null) {
            try {
                this.snapshotConfigInfoProcessor.saveSnaptshot(dataId, group, config);
            }
            catch (IOException e) {
                log.error((Object)("\u4fdd\u5b58snapshot\u51fa\u9519,dataId=" + dataId + ",group=" + group), (Throwable)e);
            }
        }
    }

    @Override
    public String getAvailableConfigureInfomation(String dataId, String group, long timeout) {
        try {
            String result = this.getConfigureInfomation(dataId, group, timeout);
            if (result != null && result.length() > 0) {
                return result;
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
        }
        if (MockServer.isTestMode()) {
            return null;
        }
        return this.getSnapshotConfiginfomation(dataId, group);
    }

    @Override
    public String getAvailableConfigureInfomationFromSnapshot(String dataId, String group, long timeout) {
        String result = this.getSnapshotConfiginfomation(dataId, group);
        if (!StringUtils.isBlank((String)result)) {
            return result;
        }
        return this.getConfigureInfomation(dataId, group, timeout);
    }

    private String getSnapshotConfiginfomation(String dataId, String group) {
        if (group == null) {
            group = "DEFAULT_GROUP";
        }
        try {
            CacheData cacheData = this.getCacheData(dataId, group);
            String config = this.snapshotConfigInfoProcessor.getConfigInfomation(dataId, group);
            if (config != null && cacheData != null) {
                cacheData.incrementFetchCountAndGet();
            }
            return config;
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6snapshot\u51fa\u9519\uff0c dataId=" + dataId + ",group=" + group), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    String getConfigureInfomation(String dataId, String group, long timeout, boolean skipContentCache) {
        this.start();
        if (!this.isRun) {
            throw new RuntimeException("DiamondSubscriber\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\u4e2d\uff0c\u65e0\u6cd5\u83b7\u53d6ConfigureInfomation");
        }
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group);
        }
        if (!skipContentCache && (content = (String)this.contentCache.get(key = this.makeCacheKey(dataId, group))) != null) {
            return content;
        }
        waitTime = 0L;
        uri = this.getUriString(dataId, group);
        if (DefaultDiamondSubscriber.log.isInfoEnabled()) {
            DefaultDiamondSubscriber.log.info((Object)uri);
        }
        cacheData = this.getCacheData(dataId, group);
        retryTimes = this.getDiamondConfigure().getRetrieveDataRetryTimes();
        DefaultDiamondSubscriber.log.info((Object)("\u8bbe\u5b9a\u7684\u83b7\u53d6\u914d\u7f6e\u6570\u636e\u7684\u91cd\u8bd5\u6b21\u6570\u4e3a\uff1a" + retryTimes));
        tryCount = 0;
lbl18:
        // 7 sources

        block18: while (0L == timeout || timeout > waitTime) {
            if (++tryCount > retryTimes + 1) {
                DefaultDiamondSubscriber.log.warn((Object)"\u5df2\u7ecf\u5230\u8fbe\u4e86\u8bbe\u5b9a\u7684\u91cd\u8bd5\u6b21\u6570");
                break;
            }
            DefaultDiamondSubscriber.log.info((Object)("\u83b7\u53d6\u914d\u7f6e\u6570\u636e\uff0c\u7b2c" + tryCount + "\u6b21\u5c1d\u8bd5, waitTime:" + waitTime));
            onceTimeOut = this.getOnceTimeOut(waitTime, timeout);
            waitTime += onceTimeOut;
            httpMethod = new GetMethod(uri);
            this.configureHttpMethod(skipContentCache, cacheData, onceTimeOut, (HttpMethod)httpMethod);
            try {
                httpStatus = this.httpClient.executeMethod((HttpMethod)httpMethod);
                switch (httpStatus) {
                    case 200: {
                        var17_21 = result = this.getSuccess(dataId, group, cacheData, (HttpMethod)httpMethod);
                        return var17_21;
                    }
                    case 304: {
                        var17_22 = result = this.getNotModified(dataId, cacheData, (HttpMethod)httpMethod);
                        return var17_22;
                    }
                    case 404: {
                        DefaultDiamondSubscriber.log.warn((Object)("\u6ca1\u6709\u627e\u5230DataID\u4e3a:" + dataId + "\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f"));
                        cacheData.setMd5("");
                        this.snapshotConfigInfoProcessor.removeSnapshot(dataId, group);
                        var16_20 = null;
                        return var16_20;
                    }
                    case 503: {
                        this.rotateToNextDomain();
                        ** break;
                    }
                    default: {
                        DefaultDiamondSubscriber.log.warn((Object)("HTTP State: " + httpStatus + ":" + this.httpClient.getState()));
                        this.rotateToNextDomain();
                        continue block18;
                    }
                }
            }
            catch (HttpException e) {
                DefaultDiamondSubscriber.log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606fHttp\u5f02\u5e38", (Throwable)e);
                this.rotateToNextDomain();
            }
            catch (IOException e) {
                DefaultDiamondSubscriber.log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606fIO\u5f02\u5e38", (Throwable)e);
                this.rotateToNextDomain();
            }
            catch (Exception e) {
                DefaultDiamondSubscriber.log.error((Object)"\u672a\u77e5\u5f02\u5e38", (Throwable)e);
                this.rotateToNextDomain();
            }
            finally {
                httpMethod.releaseConnection();
            }
        }
        throw new RuntimeException("\u83b7\u53d6ConfigureInfomation\u8d85\u65f6, DataID" + dataId + ", Group\u4e3a\uff1a" + group + ",\u8d85\u65f6\u65f6\u95f4\u4e3a\uff1a" + timeout);
    }

    private CacheData getCacheData(String dataId, String group) {
        CacheData cacheData = null;
        ConcurrentHashMap<String, CacheData> cacheDatas = this.cache.get(dataId);
        if (null != cacheDatas) {
            cacheData = cacheDatas.get(group);
        }
        if (null == cacheData) {
            cacheData = new CacheData(dataId, group);
            ConcurrentHashMap newCacheDatas = new ConcurrentHashMap();
            ConcurrentHashMap<String, CacheData> oldCacheDatas = this.cache.putIfAbsent(dataId, newCacheDatas);
            if (null == oldCacheDatas) {
                oldCacheDatas = newCacheDatas;
            }
            if (null != oldCacheDatas.putIfAbsent(group, cacheData)) {
                cacheData = (CacheData)oldCacheDatas.get(group);
            }
        }
        return cacheData;
    }

    private String getNotModified(String dataId, CacheData cacheData, HttpMethod httpMethod) {
        Header md5Header = httpMethod.getResponseHeader("Content-MD5");
        if (null == md5Header) {
            throw new RuntimeException("RP_NO_CHANGE\u8fd4\u56de\u7684\u7ed3\u679c\u4e2d\u6ca1\u6709MD5\u7801");
        }
        String md5 = md5Header.getValue();
        if (!cacheData.getMd5().equals(md5)) {
            String lastMd5 = cacheData.getMd5();
            cacheData.setMd5("");
            cacheData.setLastModifiedHeader("");
            throw new RuntimeException("MD5\u7801\u6821\u9a8c\u5bf9\u6bd4\u51fa\u9519,DataID\u4e3a:[" + dataId + "]\u4e0a\u6b21MD5\u4e3a:[" + lastMd5 + "]\u672c\u6b21MD5\u4e3a:[" + md5 + "]");
        }
        cacheData.setMd5(md5);
        this.changeSpacingInterval(httpMethod);
        if (log.isInfoEnabled()) {
            log.info((Object)("DataId: " + dataId + ", \u5bf9\u5e94\u7684configInfo\u6ca1\u6709\u53d8\u5316"));
        }
        return null;
    }

    private String getSuccess(String dataId, String group, CacheData cacheData, HttpMethod httpMethod) {
        String configInfo = "";
        configInfo = this.getContent(httpMethod);
        if (null == configInfo) {
            throw new RuntimeException("RP_OK\u83b7\u53d6\u4e86\u9519\u8bef\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        Header md5Header = httpMethod.getResponseHeader("Content-MD5");
        if (null == md5Header) {
            throw new RuntimeException("RP_OK\u8fd4\u56de\u7684\u7ed3\u679c\u4e2d\u6ca1\u6709MD5\u7801, " + configInfo);
        }
        String md5 = md5Header.getValue();
        if (!this.checkContent(configInfo, md5)) {
            throw new RuntimeException("\u914d\u7f6e\u4fe1\u606f\u7684MD5\u7801\u6821\u9a8c\u51fa\u9519,DataID\u4e3a:[" + dataId + "]\u914d\u7f6e\u4fe1\u606f\u4e3a:[" + configInfo + "]MD5\u4e3a:[" + md5 + "]");
        }
        Header lastModifiedHeader = httpMethod.getResponseHeader("Last-Modified");
        if (null == lastModifiedHeader) {
            throw new RuntimeException("RP_OK\u8fd4\u56de\u7684\u7ed3\u679c\u4e2d\u6ca1\u6709lastModifiedHeader");
        }
        String lastModified = lastModifiedHeader.getValue();
        cacheData.setMd5(md5);
        cacheData.setLastModifiedHeader(lastModified);
        this.changeSpacingInterval(httpMethod);
        String key = this.makeCacheKey(dataId, group);
        this.contentCache.put(key, (Object)configInfo);
        StringBuilder buf = new StringBuilder();
        buf.append("dataId=").append(dataId);
        buf.append(" ,group=").append(group);
        buf.append(" ,content=").append(configInfo);
        this.dataLog.info((Object)buf.toString());
        return configInfo;
    }

    private void configureHttpMethod(boolean skipContentCache, CacheData cacheData, long onceTimeOut, HttpMethod httpMethod) {
        if (skipContentCache && null != cacheData) {
            if (null != cacheData.getLastModifiedHeader() && "" != cacheData.getLastModifiedHeader()) {
                httpMethod.addRequestHeader("If-Modified-Since", cacheData.getLastModifiedHeader());
            }
            if (null != cacheData.getMd5() && "" != cacheData.getMd5()) {
                httpMethod.addRequestHeader("Content-MD5", cacheData.getMd5());
            }
        }
        httpMethod.addRequestHeader("Accept-Encoding", "gzip,deflate");
        HttpMethodParams params = new HttpMethodParams();
        params.setSoTimeout((int)onceTimeOut);
        httpMethod.setParams(params);
        this.httpClient.getHostConfiguration().setHost(this.diamondConfigure.getDomainNameList().get(this.domainNamePos.get()), this.diamondConfigure.getPort());
    }

    private String makeCacheKey(String dataId, String group) {
        String key = dataId + "-" + group;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Set<String> checkUpdateDataIds(long timeout) {
        if (!this.isRun) {
            throw new RuntimeException("DiamondSubscriber\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\u4e2d\uff0c\u65e0\u6cd5\u83b7\u53d6\u4fee\u6539\u8fc7\u7684DataID\u5217\u8868");
        }
        if (MockServer.isTestMode()) {
            return this.testData();
        }
        waitTime = 0L;
        probeUpdateString = this.getProbeUpdateString();
        if (StringUtils.isBlank((String)probeUpdateString)) {
            return null;
        }
lbl9:
        // 8 sources

        block14: while (0L == timeout || timeout > waitTime) {
            onceTimeOut = this.getOnceTimeOut(waitTime, timeout);
            waitTime += onceTimeOut;
            postMethod = new PostMethod("/diamond/config.co");
            postMethod.addParameter("Probe-Modify-Request", probeUpdateString);
            params = new HttpMethodParams();
            params.setSoTimeout((int)onceTimeOut);
            postMethod.setParams(params);
            try {
                this.httpClient.getHostConfiguration().setHost(this.diamondConfigure.getDomainNameList().get(this.domainNamePos.get()), this.diamondConfigure.getPort());
                httpStatus = this.httpClient.executeMethod((HttpMethod)postMethod);
                DefaultDiamondSubscriber.log.info((Object)httpStatus);
                switch (httpStatus) {
                    case 200: {
                        var12_12 = result = this.getUpdateDataIds((HttpMethod)postMethod);
                        return var12_12;
                    }
                    case 503: {
                        this.rotateToNextDomain();
                        ** break;
                    }
                    default: {
                        DefaultDiamondSubscriber.log.warn((Object)("\u83b7\u53d6\u4fee\u6539\u8fc7\u7684DataID\u5217\u8868\u7684\u8bf7\u6c42\u56de\u5e94\u7684HTTP State: " + httpStatus));
                        this.rotateToNextDomain();
                        continue block14;
                    }
                }
            }
            catch (HttpException e) {
                DefaultDiamondSubscriber.log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606fHttp\u5f02\u5e38", (Throwable)e);
                this.rotateToNextDomain();
            }
            catch (IOException e) {
                DefaultDiamondSubscriber.log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606fIO\u5f02\u5e38", (Throwable)e);
                this.rotateToNextDomain();
            }
            catch (Exception e) {
                DefaultDiamondSubscriber.log.error((Object)"\u672a\u77e5\u5f02\u5e38", (Throwable)e);
                this.rotateToNextDomain();
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        throw new RuntimeException("\u83b7\u53d6\u4fee\u6539\u8fc7\u7684DataID\u5217\u8868\u8d85\u65f6 " + this.diamondConfigure.getDomainNameList().get(this.domainNamePos.get()) + ", \u8d85\u65f6\u65f6\u95f4\u4e3a\uff1a" + timeout);
    }

    private Set<String> testData() {
        HashSet<String> dataIdList = new HashSet<String>();
        for (String dataId : this.cache.keySet()) {
            ConcurrentHashMap<String, CacheData> cacheDatas = this.cache.get(dataId);
            for (String group : cacheDatas.keySet()) {
                if (null == MockServer.getUpdateConfigInfo(dataId, group)) continue;
                dataIdList.add(dataId + Constants.WORD_SEPARATOR + group);
            }
        }
        return dataIdList;
    }

    private String getProbeUpdateString() {
        StringBuilder probeModifyBuilder = new StringBuilder();
        for (Map.Entry<String, ConcurrentHashMap<String, CacheData>> cacheDatasEntry : this.cache.entrySet()) {
            String dataId = cacheDatasEntry.getKey();
            ConcurrentHashMap<String, CacheData> cacheDatas = cacheDatasEntry.getValue();
            if (null == cacheDatas) continue;
            for (Map.Entry<String, CacheData> cacheDataEntry : cacheDatas.entrySet()) {
                CacheData data = cacheDataEntry.getValue();
                if (data.isUseLocalConfigInfo()) continue;
                probeModifyBuilder.append(dataId).append(Constants.WORD_SEPARATOR);
                if (null != cacheDataEntry.getValue().getGroup() && "" != cacheDataEntry.getValue().getGroup()) {
                    probeModifyBuilder.append(cacheDataEntry.getValue().getGroup()).append(Constants.WORD_SEPARATOR);
                } else {
                    probeModifyBuilder.append(Constants.WORD_SEPARATOR);
                }
                if (null != cacheDataEntry.getValue().getMd5() && "" != cacheDataEntry.getValue().getMd5()) {
                    probeModifyBuilder.append(cacheDataEntry.getValue().getMd5()).append(Constants.LINE_SEPARATOR);
                    continue;
                }
                probeModifyBuilder.append(Constants.LINE_SEPARATOR);
            }
        }
        String probeModifyString = probeModifyBuilder.toString();
        return probeModifyString;
    }

    synchronized void rotateToNextDomain() {
        int domainNameCount = this.diamondConfigure.getDomainNameList().size();
        int index = this.domainNamePos.incrementAndGet();
        if (index < 0) {
            index = -index;
        }
        if (domainNameCount == 0) {
            log.error((Object)"diamond\u670d\u52a1\u5668\u5730\u5740\u5217\u8868\u957f\u5ea6\u4e3a\u96f6, \u8bf7\u8054\u7cfb\u8d1f\u8d23\u4eba\u6392\u67e5");
            return;
        }
        this.domainNamePos.set(index % domainNameCount);
        if (this.diamondConfigure.getDomainNameList().size() > 0) {
            log.warn((Object)("\u8f6e\u6362DiamondServer\u57df\u540d\u5230\uff1a" + this.diamondConfigure.getDomainNameList().get(this.domainNamePos.get())));
        }
    }

    String getUriString(String dataId, String group) {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("/diamond/config.co");
        uriBuilder.append("?");
        uriBuilder.append("dataId").append("=").append(dataId);
        if (null != group) {
            uriBuilder.append("&");
            uriBuilder.append("group").append("=").append(group);
        }
        return uriBuilder.toString();
    }

    void changeSpacingInterval(HttpMethod httpMethod) {
        Header[] spacingIntervalHeaders = httpMethod.getResponseHeaders("client-spacing-interval");
        if (spacingIntervalHeaders.length >= 1) {
            try {
                this.diamondConfigure.setPollingIntervalTime(Integer.parseInt(spacingIntervalHeaders[0].getValue()));
            }
            catch (RuntimeException e) {
                log.error((Object)"\u8bbe\u7f6e\u4e0b\u6b21\u95f4\u9694\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getContent(HttpMethod httpMethod) {
        StringBuilder contentBuilder = new StringBuilder();
        if (this.isZipContent(httpMethod)) {
            InputStream is = null;
            GZIPInputStream gzin = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                is = httpMethod.getResponseBodyAsStream();
                gzin = new GZIPInputStream(is);
                isr = new InputStreamReader((InputStream)gzin, ((HttpMethodBase)httpMethod).getResponseCharSet());
                br = new BufferedReader(isr);
                char[] buffer = new char[4096];
                int readlen = -1;
                while ((readlen = br.read(buffer, 0, 4096)) != -1) {
                    contentBuilder.append(buffer, 0, readlen);
                }
            }
            catch (Exception e) {
                log.error((Object)"\u89e3\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e1) {}
                try {
                    isr.close();
                }
                catch (Exception e1) {}
                try {
                    gzin.close();
                }
                catch (Exception e1) {}
                try {
                    is.close();
                }
                catch (Exception e1) {}
            }
        } else {
            String content = null;
            try {
                content = httpMethod.getResponseBodyAsString();
            }
            catch (Exception e) {
                log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
            if (null == content) {
                return null;
            }
            contentBuilder.append(content);
        }
        return contentBuilder.toString();
    }

    Set<String> getUpdateDataIdsInBody(HttpMethod httpMethod) {
        HashSet<String> modifiedDataIdSet = new HashSet<String>();
        try {
            String modifiedDataIdsString = httpMethod.getResponseBodyAsString();
            return this.convertStringToSet(modifiedDataIdsString);
        }
        catch (Exception exception) {
            return modifiedDataIdSet;
        }
    }

    Set<String> getUpdateDataIds(HttpMethod httpMethod) {
        return this.getUpdateDataIdsInBody(httpMethod);
    }

    private Set<String> convertStringToSet(String modifiedDataIdsString) {
        String[] modifiedDataIdStrings;
        if (null == modifiedDataIdsString || "".equals(modifiedDataIdsString)) {
            return null;
        }
        HashSet<String> modifiedDataIdSet = new HashSet<String>();
        try {
            modifiedDataIdsString = URLDecoder.decode(modifiedDataIdsString, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)"\u89e3\u7801modifiedDataIdsString\u51fa\u9519", (Throwable)e);
        }
        if (log.isInfoEnabled() && modifiedDataIdsString != null) {
            if (modifiedDataIdsString.startsWith("OK")) {
                log.debug((Object)("\u63a2\u6d4b\u7684\u8fd4\u56de\u7ed3\u679c:" + modifiedDataIdsString));
            } else {
                log.info((Object)("\u63a2\u6d4b\u5230\u6570\u636e\u53d8\u5316:" + modifiedDataIdsString));
            }
        }
        for (String modifiedDataIdString : modifiedDataIdStrings = modifiedDataIdsString.split(Constants.LINE_SEPARATOR)) {
            if ("".equals(modifiedDataIdString)) continue;
            modifiedDataIdSet.add(modifiedDataIdString);
        }
        return modifiedDataIdSet;
    }

    boolean checkContent(String configInfo, String md5) {
        String realMd5 = MD5.getInstance().getMD5String(configInfo);
        return realMd5 == null ? md5 == null : realMd5.equals(md5);
    }

    boolean isZipContent(HttpMethod httpMethod) {
        String acceptEncoding;
        return null != httpMethod.getResponseHeader("Content-Encoding") && (acceptEncoding = httpMethod.getResponseHeader("Content-Encoding").getValue()).toLowerCase().indexOf("gzip") > -1;
    }

    @Override
    public void setSubscriberListener(SubscriberListener subscriberListener) {
        this.subscriberListener = subscriberListener;
    }

    @Override
    public SubscriberListener getSubscriberListener() {
        return this.subscriberListener;
    }

    @Override
    public void addDataId(String dataId, String group) {
        CacheData cacheData;
        ConcurrentHashMap<String, CacheData> cacheDatas;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5   HH:mm:ss");
        log.info((Object)("diamond client start:" + formatter.format(new Date(System.currentTimeMillis()))));
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (null == (cacheDatas = this.cache.get(dataId))) {
            ConcurrentHashMap newCacheDatas = new ConcurrentHashMap();
            ConcurrentHashMap oldCacheDatas = this.cache.putIfAbsent(dataId, newCacheDatas);
            cacheDatas = null != oldCacheDatas ? oldCacheDatas : newCacheDatas;
        }
        if (null == (cacheData = cacheDatas.get(group))) {
            cacheDatas.putIfAbsent(group, new CacheData(dataId, group));
            if (log.isInfoEnabled()) {
                log.info((Object)("\u6dfb\u52a0\u4e86DataID[" + dataId + "]\uff0c\u5176Group\u4e3a" + group));
            }
            this.start();
        }
    }

    @Override
    public void addDataId(String dataId) {
        this.addDataId(dataId, null);
    }

    @Override
    public boolean containDataId(String dataId) {
        return this.containDataId(dataId, null);
    }

    @Override
    public boolean containDataId(String dataId, String group) {
        ConcurrentHashMap<String, CacheData> cacheDatas;
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (null == (cacheDatas = this.cache.get(dataId))) {
            return false;
        }
        return cacheDatas.containsKey(group);
    }

    @Override
    public void clearAllDataIds() {
        this.cache.clear();
    }

    @Override
    public Set<String> getDataIds() {
        return new HashSet<String>(this.cache.keySet());
    }

    @Override
    public ConcurrentHashMap<String, ConcurrentHashMap<String, CacheData>> getCache() {
        return this.cache;
    }

    @Override
    public void removeDataId(String dataId) {
        this.removeDataId(dataId, null);
    }

    @Override
    public synchronized void removeDataId(String dataId, String group) {
        ConcurrentHashMap<String, CacheData> cacheDatas;
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (null == (cacheDatas = this.cache.get(dataId))) {
            return;
        }
        cacheDatas.remove(group);
        log.warn((Object)("\u5220\u9664\u4e86DataID[" + dataId + "]\u4e2d\u7684Group: " + group));
        if (cacheDatas.size() == 0) {
            this.cache.remove(dataId);
            log.warn((Object)("\u5220\u9664\u4e86DataID[" + dataId + "]"));
        }
    }

    @Override
    public DiamondConfigure getDiamondConfigure() {
        return this.diamondConfigure;
    }

    @Override
    public void setDiamondConfigure(DiamondConfigure diamondConfigure) {
        if (!this.isRun) {
            this.diamondConfigure = diamondConfigure;
        } else {
            this.copyDiamondConfigure(diamondConfigure);
        }
    }

    private void copyDiamondConfigure(DiamondConfigure diamondConfigure) {
    }

    static {
        try {
            LoggerInit.initLogFromBizLog();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

