/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.client.processor;

import cn.leancloud.diamond.configinfo.CacheData;
import cn.leancloud.diamond.io.FileSystem;
import cn.leancloud.diamond.io.Path;
import cn.leancloud.diamond.io.watch.StandardWatchEventKind;
import cn.leancloud.diamond.io.watch.WatchEvent;
import cn.leancloud.diamond.io.watch.WatchKey;
import cn.leancloud.diamond.io.watch.WatchService;
import cn.leancloud.diamond.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalConfigInfoProcessor {
    private static final Log log = LogFactory.getLog(LocalConfigInfoProcessor.class);
    private ScheduledExecutorService singleExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, Long> existFiles = new HashMap<String, Long>();
    private volatile boolean isRun;
    private String rootPath = null;

    public String getLocalConfigureInfomation(CacheData cacheData, boolean force) throws IOException {
        String filePath = this.getFilePath(cacheData.getDataId(), cacheData.getGroup());
        if (!this.existFiles.containsKey(filePath)) {
            if (cacheData.isUseLocalConfigInfo()) {
                cacheData.setLastModifiedHeader("");
                cacheData.setMd5("");
                cacheData.setLocalConfigInfoFile(null);
                cacheData.setLocalConfigInfoVersion(0L);
                cacheData.setUseLocalConfigInfo(false);
            }
            return null;
        }
        if (force) {
            log.info((Object)("\u4e3b\u52a8\u4ece\u672c\u5730\u83b7\u53d6\u914d\u7f6e\u6570\u636e, dataId:" + cacheData.getDataId() + ", group:" + cacheData.getGroup()));
            String content = FileUtils.getFileContent((String)filePath);
            return content;
        }
        if (!filePath.equals(cacheData.getLocalConfigInfoFile()) || this.existFiles.get(filePath).longValue() != cacheData.getLocalConfigInfoVersion()) {
            String content = FileUtils.getFileContent((String)filePath);
            cacheData.setLocalConfigInfoFile(filePath);
            cacheData.setLocalConfigInfoVersion(this.existFiles.get(filePath));
            cacheData.setUseLocalConfigInfo(true);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u672c\u5730\u914d\u7f6e\u6570\u636e\u53d1\u751f\u53d8\u5316, dataId:" + cacheData.getDataId() + ", group:" + cacheData.getGroup()));
            }
            return content;
        }
        cacheData.setUseLocalConfigInfo(true);
        if (log.isInfoEnabled()) {
            log.debug((Object)("\u672c\u5730\u914d\u7f6e\u6570\u636e\u6ca1\u6709\u53d1\u751f\u53d8\u5316, dataId:" + cacheData.getDataId() + ", group:" + cacheData.getGroup()));
        }
        return null;
    }

    String getFilePath(String dataId, String group) {
        StringBuilder filePathBuilder = new StringBuilder();
        filePathBuilder.append(this.rootPath).append("/").append("config-data").append("/").append(group).append("/").append(dataId);
        File file = new File(filePathBuilder.toString());
        return file.getAbsolutePath();
    }

    public synchronized void start(String rootPath) {
        if (this.isRun) {
            return;
        }
        this.rootPath = rootPath;
        this.isRun = true;
        if (this.singleExecutor == null || this.singleExecutor.isTerminated()) {
            this.singleExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.initDataDir(rootPath);
        this.startCheckLocalDir(rootPath);
    }

    private void initDataDir(String rootPath) {
        try {
            File flie = new File(rootPath);
            flie.mkdir();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        if (!this.isRun) {
            return;
        }
        this.isRun = false;
        this.singleExecutor.shutdownNow();
        this.singleExecutor = null;
    }

    private void startCheckLocalDir(String filePath) {
        final WatchService watcher = FileSystem.getDefault().newWatchService();
        Path path = new Path(new File(filePath));
        watcher.register(path, true, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY});
        this.checkAtFirst(watcher);
        this.singleExecutor.execute(new Runnable(){

            public void run() {
                log.debug((Object)">>>>>>\u5df2\u7ecf\u5f00\u59cb\u76d1\u63a7\u76ee\u5f55<<<<<<");
                while (LocalConfigInfoProcessor.this.isRun) {
                    WatchKey key;
                    try {
                        key = watcher.take();
                    }
                    catch (InterruptedException x) {
                        continue;
                    }
                    if (LocalConfigInfoProcessor.this.processEvents(key)) continue;
                    log.error((Object)"reset unvalid,\u76d1\u63a7\u670d\u52a1\u5931\u6548");
                    break;
                }
                log.debug((Object)">>>>>>\u9000\u51fa\u76d1\u63a7\u76ee\u5f55<<<<<<");
                watcher.close();
            }
        });
    }

    private void checkAtFirst(WatchService watcher) {
        watcher.check();
        WatchKey key = null;
        while ((key = watcher.poll()) != null) {
            this.processEvents(key);
        }
    }

    private boolean processEvents(WatchKey key) {
        Iterator i$ = key.pollEvents().iterator();
        while (i$.hasNext()) {
            String grandpaDir;
            WatchEvent event;
            WatchEvent ev = event = (WatchEvent)i$.next();
            Path eventPath = (Path)ev.context();
            String realPath = eventPath.getAbsolutePath();
            if (ev.kind() == StandardWatchEventKind.ENTRY_CREATE || ev.kind() == StandardWatchEventKind.ENTRY_MODIFY) {
                grandpaDir = null;
                try {
                    grandpaDir = FileUtils.getGrandpaDir((String)realPath);
                }
                catch (Exception e1) {
                    // empty catch block
                }
                if (!"config-data".equals(grandpaDir)) {
                    log.error((Object)("\u65e0\u6548\u7684\u6587\u4ef6\u8fdb\u5165\u76d1\u63a7\u76ee\u5f55: " + realPath));
                    continue;
                }
                this.existFiles.put(realPath, System.currentTimeMillis());
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(realPath + "\u6587\u4ef6\u88ab\u6dfb\u52a0\u6216\u66f4\u65b0"));
                continue;
            }
            if (ev.kind() != StandardWatchEventKind.ENTRY_DELETE) continue;
            grandpaDir = null;
            try {
                grandpaDir = FileUtils.getGrandpaDir((String)realPath);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if ("config-data".equals(grandpaDir)) {
                this.existFiles.remove(realPath);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(realPath + "\u6587\u4ef6\u88ab\u88ab\u5220\u9664"));
                continue;
            }
            HashSet<String> keySet = new HashSet<String>(this.existFiles.keySet());
            for (String filePath : keySet) {
                if (!filePath.startsWith(realPath)) continue;
                this.existFiles.remove(filePath);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(filePath + "\u6587\u4ef6\u88ab\u5220\u9664"));
            }
        }
        return key.reset();
    }
}

