/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.client.impl;

import cn.leancloud.diamond.client.SubscriberListener;
import cn.leancloud.diamond.configinfo.ConfigureInfomation;
import cn.leancloud.diamond.manager.ManagerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriberListener
implements SubscriberListener {
    private static final Log dataLog = LogFactory.getLog((String)"DiamondConfigDataLog");
    private final ConcurrentMap<String, CopyOnWriteArrayList<ManagerListener>> allListeners = new ConcurrentHashMap<String, CopyOnWriteArrayList<ManagerListener>>();

    @Override
    public Executor getExecutor() {
        return null;
    }

    @Override
    public void receiveConfigInfo(ConfigureInfomation configureInfomation) {
        String dataId = configureInfomation.getDataId();
        String group = configureInfomation.getGroup();
        if (null == dataId) {
            dataLog.error((Object)"[receiveConfigInfo] dataId is null");
            return;
        }
        String key = this.makeKey(dataId, group);
        CopyOnWriteArrayList listeners = (CopyOnWriteArrayList)this.allListeners.get(key);
        if (listeners == null || listeners.isEmpty()) {
            dataLog.warn((Object)("[notify-listener] no listener for dataId=" + dataId + ", group=" + group));
            return;
        }
        for (ManagerListener listener : listeners) {
            try {
                this.notifyListener(configureInfomation, listener);
            }
            catch (Throwable t) {
                dataLog.error((Object)("call listener error, dataId=" + dataId + ", group=" + group), t);
            }
        }
    }

    private void notifyListener(ConfigureInfomation configureInfomation, final ManagerListener listener) {
        if (listener == null) {
            return;
        }
        String dataId = configureInfomation.getDataId();
        String group = configureInfomation.getGroup();
        final String content = configureInfomation.getConfigureInfomation();
        dataLog.info((Object)("[notify-listener] call listener " + listener.getClass().getName() + ", for " + dataId + ", " + group + ", " + content));
        Runnable job = new Runnable(){

            public void run() {
                try {
                    listener.receiveConfigInfo(content);
                }
                catch (Throwable t) {
                    dataLog.error((Object)t.getMessage(), t);
                }
            }
        };
        if (null != listener.getExecutor()) {
            listener.getExecutor().execute(job);
        } else {
            job.run();
        }
    }

    public void addManagerListener(String dataId, String group, ManagerListener listener) {
        ArrayList<ManagerListener> list = new ArrayList<ManagerListener>();
        list.add(listener);
        this.addManagerListeners(dataId, group, list);
    }

    public List<ManagerListener> getManagerListenerList(String dataId, String group) {
        if (null == dataId) {
            return null;
        }
        String key = this.makeKey(dataId, group);
        return new ArrayList<ManagerListener>((Collection)this.allListeners.get(key));
    }

    public void removeManagerListeners(String dataId, String group) {
        if (null == dataId) {
            return;
        }
        String key = this.makeKey(dataId, group);
        this.allListeners.remove(key);
    }

    public void addManagerListeners(String dataId, String group, List<ManagerListener> addListeners) {
        CopyOnWriteArrayList oldList;
        if (null == dataId || null == addListeners) {
            return;
        }
        if (addListeners.size() == 0) {
            return;
        }
        String key = this.makeKey(dataId, group);
        CopyOnWriteArrayList<ManagerListener> listenerList = (CopyOnWriteArrayList<ManagerListener>)this.allListeners.get(key);
        if (listenerList == null && (oldList = this.allListeners.putIfAbsent(key, listenerList = new CopyOnWriteArrayList<ManagerListener>())) != null) {
            listenerList = oldList;
        }
        listenerList.addAll(addListeners);
    }

    private String makeKey(String dataId, String group) {
        if (StringUtils.isBlank((String)group)) {
            group = "DEFAULT_GROUP";
        }
        return dataId + "_" + group;
    }
}

