(ns clojush.zip
  (:gen-class)
  (:require [clojush] [clojure.zip :as zip])
  (:use [clojush]))

(in-ns 'clojush)

;; Redefine push-types to include :intvec2D and then redefine the push state structure.
(def push-types (cons :zip push-types))
(define-push-state-structure)

(in-ns 'clojush.zip)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; zip instructions

(define-registered zip_next
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (second (top-item :zip state))))
      state
      (push-item (zip/next (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_prev
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (second (top-item :zip state)))
	    (nil? (zip/prev (top-item :zip state))))
      state
      (push-item (zip/prev (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_down
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/down (top-item :zip state))))
      state
      (push-item (zip/down (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_up
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/up (top-item :zip state))))
      state
      (push-item (zip/up (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_left
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (second (top-item :zip state)))
	    (nil? (:l (top-item :zip state))))
      state
      (push-item (zip/left (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_right
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (second (top-item :zip state)))
	    (nil? (:r (top-item :zip state))))
      state
      (push-item (zip/right (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_end?
  (fn [state]
    (if (empty? (:zip state))
      state
      (push-item (zip/end? (top-item :zip state)) :boolean (pop-item :zip state)))))

(define-registered zip_replace
  (fn [state]
    (if (or (empty? (:zip state))
	    (empty? (:code state))
	    (keyword? (:code state)))
      state
      (push-item (zip/replace (top-item :zip state)
			      (top-item :code state)) 
		 :zip
		 (pop-item :code (pop-item :zip state))))))

(define-registered code_fromzip
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (second (top-item :zip state))))
      state
      (push-item (zip/node (top-item :zip state)) :code (pop-item :zip state)))))

(define-registered code_fromziproot
  (fn [state]
    (if (empty? (:zip state))
      state
      (push-item (zip/root (top-item :zip state)) :code (pop-item :zip state)))))

(define-registered zip_fromcode
  (fn [state]
    (if (empty? (:code state))
      state
      (push-item (zip/seq-zip (top-item :code state)) :zip (pop-item :code state)))))

(define-registered zip_yankdup (yankduper :zip))
(define-registered zip_dup (duper :zip))
(define-registered zip_pop (popper :zip))
(define-registered zip_swap (swapper :zip))
(define-registered zip_rot (rotter :zip))
(define-registered zip_flush (flusher :zip))
(define-registered zip_eq (eqer :zip))
(define-registered zip_stackdepth (stackdepther :zip))
(define-registered zip_yank (yanker :zip))
(define-registered zip_shove (shover :zip))
