/*
 * Decompiled with CFR 0.152.
 */
package clojure.osgi.internal;

import clojure.lang.Compiler;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import clojure.osgi.RunnableWithException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ClojureOSGi {
    private static final Var REQUIRE = RT.var("clojure.core", "require");
    private static final Var WITH_BUNDLE = RT.var("clojure.osgi.core", "with-bundle*");
    private static final Var BUNDLE = RT.var("clojure.osgi.core", "*bundle*").setDynamic();
    private static boolean s_Initialized;

    public static void initialize(final BundleContext aContext) throws Exception {
        if (!s_Initialized) {
            RT.var("clojure.osgi.core", "*clojure-osgi-bundle*", aContext.getBundle());
            ClojureOSGi.withLoader(ClojureOSGi.class.getClassLoader(), new RunnableWithException(){

                @Override
                public Object run() {
                    boolean pushed = false;
                    try {
                        REQUIRE.invoke(Symbol.intern("clojure.main"));
                        Var.pushThreadBindings(RT.map(BUNDLE, aContext.getBundle()));
                        pushed = true;
                        REQUIRE.invoke(Symbol.intern("clojure.osgi.core"));
                        REQUIRE.invoke(Symbol.intern("clojure.osgi.services"));
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("cannot initialize clojure.osgi", e2);
                    }
                    finally {
                        if (pushed) {
                            Var.popThreadBindings();
                        }
                    }
                    return null;
                }
            });
            s_Initialized = true;
        }
    }

    public static void require(Bundle aBundle, final String aName) {
        try {
            ClojureOSGi.withBundle(aBundle, new RunnableWithException(){

                @Override
                public Object run() throws Exception {
                    REQUIRE.invoke(Symbol.intern(aName));
                    return null;
                }
            });
        }
        catch (Exception aEx) {
            aEx.printStackTrace();
            throw new RuntimeException(aEx);
        }
    }

    public static Object withLoader(ClassLoader aLoader, RunnableWithException aRunnable) throws Exception {
        try {
            Var.pushThreadBindings(RT.map(Compiler.LOADER, aLoader));
            Object object = aRunnable.run();
            return object;
        }
        finally {
            Var.popThreadBindings();
        }
    }

    static Object withBundle(Bundle aBundle, RunnableWithException aCode) throws Exception {
        return WITH_BUNDLE.invoke(aBundle, false, aCode);
    }
}

