/*
 * Decompiled with CFR 0.152.
 */
package clojure.osgi;

import java.net.URL;
import org.osgi.framework.Bundle;

public class BundleClassLoader
extends ClassLoader {
    private Bundle _bundle;
    private boolean _forceDirect;

    public BundleClassLoader(Bundle bundle) {
        this(bundle, false);
    }

    public BundleClassLoader(Bundle bundle, boolean forceDirect) {
        this._bundle = bundle;
        this._forceDirect = forceDirect;
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        return this._bundle.loadClass(name2);
    }

    @Override
    public URL getResource(String name2) {
        if (this._forceDirect) {
            return this._bundle.getEntry(name2);
        }
        return this._bundle.getResource(name2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BundleClassLoader");
        sb.append("{_bundle=").append(this._bundle);
        sb.append(",_forceDirect=").append(this._forceDirect ? "true" : "false");
        sb.append('}');
        return sb.toString();
    }
}

