(ns clojusc.env-ini.common-env
  "ENV-specific Utility Functions."
  (:require [clojure.string :as string]
            [clojusc.env-ini.util :as util]
            #?(:cljs [goog.string :as gstring]
                     [goog.string.format]))
  (:refer-clojure :exclude [get read]))

(defn str->envstr [str]
  (-> str
      (string/upper-case)
      (util/dash->under)))

(defn keyword->envstr [kwd]
  (-> kwd
      (name)
      (string/upper-case)
      (util/dash->under)))

(defn envstr->keyword [str]
  (-> str
      (util/under->dash)
      (string/lower-case)
      (keyword)))

(defn envstrs->keywords [data]
  (zipmap
    (map envstr->keyword (keys data))
    (vals data)))

(defn section-key->env
  ""
  ([key]
    (keyword->envstr key))
  ([section key]
    #?(:cljs (gstring/format "%s_%s" (keyword->envstr section)
                                     (keyword->envstr key)))
    #?(:clj (format "%s_%s" (keyword->envstr section)
                            (keyword->envstr key)))))
