(ns clojurewerkz.quartzite-rest.core
  (:use noir.core clojurewerkz.quartzite-rest.conversions)
  (:require [noir.server :as server]
            [clojurewerkz.quartzite.scheduler :as scheduler]
            [clojurewerkz.quartzite.matchers  :as matchers]

            [clostache.parser     :as clstch]

            [noir.response        :as response]))

(defpage [:get "/api/v1/scheduler/groups"] {}
  (response/json
   (scheduler/get-job-group-names)))

(defpage "/api/v1/scheduler/groups/:group/triggers"
  {:keys [group]}
  (let [matcher  (matchers/group-equals group)
        triggers (scheduler/get-matching-triggers matcher)]
    (response/json (map to-hash triggers))))

(defpage "/api/v1/scheduler/groups/:group/jobs"
  {:keys [group]}
  (let [matcher  (matchers/group-equals group)
        jobs     (scheduler/get-matching-jobs matcher)]
    (println jobs)
    (response/json (map to-hash jobs))))

(defn initialize-quartz
  []
  (scheduler/initialize)
  (scheduler/start))

(defn start-server!
  []
  (server/start 8080))