(ns clojurewerkz.perfometer.net
  (:require [clojurewerkz.perfometer.util :refer :all]))

(def receive-fields [:bytes
                     :packets
                     :errs
                     :drop
                     :fifo
                     :frame
                     :compressed
                     :multicast])

(def transmit-fields [:bytes
                      :packets
                      :errs
                      :drop
                      :fifo
                      :colls
                      :carrier
                      :compressed])

(defn- parse-net-line
  [s]
  (let [id   (.trim (second (re-find semicolon-re s)))
        vals (map parse-int (next (remove empty? (split-by-spaces s))))]
    [id {:receive (zipmap receive-fields vals)
         :transmit (zipmap transmit-fields (drop (count receive-fields) vals))}]))

(defn parse-net
  [net-contents]
  (->> (clojure.string/split net-contents #"\n")
       (remove contains-pipe?)
       (map parse-net-line)
       (reduce (fn [acc [path v]]
                 (assoc acc path v)) {})))
