(ns clojurewerkz.perfometer.meminfo
  (:require [clojurewerkz.perfometer.util :refer :all]))

(def mappings {"MemTotal"     :mem-total
               "MemFree"      :mem-free
               "Buffers"      :buffers
               "Cached"       :cached
               "SwapCached"   :swap-cached
               "Active"       :active
               "Inactive"     :inactive
               "SwapTotal"    :swap-total
               "SwapFree"     :swap-free
               "Dirty"        :dirty
               "Writeback"    :writeback
               "Mapped"       :mapped
               "Slab"         :slab
               "CommitLimit"  :commit-limit
               "Committed_AS" :commited-as})

(def mapping-keys (keys mappings))

(defn parse-meminfo-line
  [s]
  (when-let [id (get mappings (.trim (second (re-find semicolon-re s))))]
    [[id] (->> s
               split-by-spaces
               (remove empty?)
               second
               parse-int)]))

(defn parse-meminfo
  [meminfo-contents]
  (->> (clojure.string/split meminfo-contents #"\n")
       (map parse-meminfo-line)
       (filter identity)
       (reduce (fn [acc [path v]]
                 (assoc-in acc path v)) {})))
