(ns clojurewerkz.perfometer.jvm
  (:import [com.codahale.metrics.jvm GarbageCollectorMetricSet MemoryUsageGaugeSet ThreadStatesGaugeSet FileDescriptorRatioGauge]))

(defn- get-metrics
  [metric-set]
  (into {}
        (mapv (fn [[a b]] [a (.getValue b)]) (.getMetrics metric-set))))

(defn garbage-collector-metrics
  []
  (get-metrics (GarbageCollectorMetricSet.)))

(defn memory-usage-metrics
  []
  (get-metrics (MemoryUsageGaugeSet.)))

(defn thread-state-metrics
  []
  (get-metrics (ThreadStatesGaugeSet.)))

(defn fd-ratio
  []
  (.getValue (FileDescriptorRatioGauge.)))

;; (map (fn [[a b]] [a (.getValue b)]) (.getMetrics (ClassLoadingGaugeSet.)))
