package clojurewerkz.mold;

import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.rest.CloudControllerClient;
import org.cloudfoundry.client.lib.rest.CloudControllerClientFactory;

import java.net.URL;

public class MoldCFClient extends CloudFoundryClient implements CloudFoundryOperations {
  /**
   * Construct client for anonymous user. Useful only to get to the '/info' endpoint.
   *
   * @param cloudControllerUrl
   */
  public MoldCFClient(URL cloudControllerUrl) {
    super(cloudControllerUrl);
  }

  public MoldCFClient(URL cloudControllerUrl, boolean trustSelfSignedCerts) {
    super(cloudControllerUrl, trustSelfSignedCerts);
  }

  public MoldCFClient(URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration) {
    super(cloudControllerUrl, httpProxyConfiguration);
  }

  public MoldCFClient(URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
    super(cloudControllerUrl, httpProxyConfiguration, trustSelfSignedCerts);
  }

  /**
   * Construct client without a default org and space.
   *
   * @param credentials
   * @param cloudControllerUrl
   */
  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl) {
    super(credentials, cloudControllerUrl);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, boolean trustSelfSignedCerts) {
    super(credentials, cloudControllerUrl, trustSelfSignedCerts);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration) {
    super(credentials, cloudControllerUrl, httpProxyConfiguration);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
    super(credentials, cloudControllerUrl, httpProxyConfiguration, trustSelfSignedCerts);
  }

  /**
   * Construct a client with a default CloudSpace.
   *
   * @param credentials
   * @param cloudControllerUrl
   * @param sessionSpace
   */
  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace) {
    super(credentials, cloudControllerUrl, sessionSpace);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace, boolean trustSelfSignedCerts) {
    super(credentials, cloudControllerUrl, sessionSpace, trustSelfSignedCerts);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace, HttpProxyConfiguration httpProxyConfiguration) {
    super(credentials, cloudControllerUrl, sessionSpace, httpProxyConfiguration);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
    super(credentials, cloudControllerUrl, sessionSpace, httpProxyConfiguration, trustSelfSignedCerts);
  }

  /**
   * Construct a client with a default space name and org name.
   *
   * @param credentials
   * @param cloudControllerUrl
   * @param orgName
   * @param spaceName
   */
  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName) {
    super(credentials, cloudControllerUrl, orgName, spaceName);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName, boolean trustSelfSignedCerts) {
    super(credentials, cloudControllerUrl, orgName, spaceName, trustSelfSignedCerts);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName, HttpProxyConfiguration httpProxyConfiguration) {
    super(credentials, cloudControllerUrl, orgName, spaceName, httpProxyConfiguration);
  }

  public MoldCFClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
    super(credentials, cloudControllerUrl, orgName, spaceName, httpProxyConfiguration, trustSelfSignedCerts);
  }

  @Override
  protected CloudControllerClient newCloudControllerClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName) {
    return super.newCloudControllerClient(credentials, cloudControllerUrl, orgName, spaceName);
  }

  @Override
  protected CloudControllerClientFactory newCloudControllerClientFactory(HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
    return new MoldCCClientFactory(httpProxyConfiguration, trustSelfSignedCerts);
  }
}
