package clojurewerkz.mold;

import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.oauth2.OauthClient;
import org.cloudfoundry.client.lib.rest.CloudControllerClient;
import org.cloudfoundry.client.lib.rest.CloudControllerClientFactory;
import org.cloudfoundry.client.lib.rest.CloudControllerClientImpl;
import org.cloudfoundry.client.lib.rest.LoggregatorClient;

import java.net.URL;

public class MoldCCClientFactory extends CloudControllerClientFactory {
  public MoldCCClientFactory(HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
    super(httpProxyConfiguration, trustSelfSignedCerts);
  }



  @Override
  protected CloudControllerClient instantiateCloudControllerClient(URL cloudControllerUrl,
                                                                   CloudCredentials cloudCredentials,
                                                                   CloudSpace sessionSpace,
                                                                   OauthClient oauthClient,
                                                                   LoggregatorClient loggregatorClient) {
    return new MoldCCClientImpl(cloudControllerUrl, restTemplate, oauthClient, loggregatorClient,
        cloudCredentials, sessionSpace);
  }

  @Override
  protected CloudControllerClientImpl instantiateCloudControllerClient(URL cloudControllerUrl,
                                                                       CloudCredentials cloudCredentials,
                                                                       String orgName,
                                                                       String spaceName,
                                                                       OauthClient oauthClient,
                                                                       LoggregatorClient loggregatorClient) {
    return new MoldCCClientImpl(cloudControllerUrl, restTemplate, oauthClient, loggregatorClient,
        cloudCredentials, orgName, spaceName);
  }
}
