# Mold, a Clojure Client for CloudFoundry

Mold is a Clojure client for CloudFoundry built on top of the official
[Java client](https://github.com/cloudfoundry/cf-java-client).


## Project Goals

 * Be reasonably feature complete
 * Be easy to use
 * Be reasonably well tested

## Project Maturity

Mold is *very* young and incomplete.


## Artifacts

Mold artifacts are [released to Clojars](https://clojars.org/clojurewerkz/mold). If you are using Maven, add the following repository
definition to your `pom.xml`:

``` xml
<repository>
  <id>clojars.org</id>
  <url>http://clojars.org/repo</url>
</repository>
```

### The Most Recent Release

With Leiningen:

    [clojurewerkz/mold "1.0.0-alpha1"]


With Maven:

    <dependency>
      <groupId>clojurewerkz</groupId>
      <artifactId>mold</artifactId>
      <version>1.0.0-alpha1</version>
    </dependency>


## Documentation & Examples

Mold API is changing very rapidly. This section will be updated when its time
to begin writing documentation.


## Community & Support

Mold uses [Clojure mailing
list](https://groups.google.com/forum/#!forum/clojure). Feel free to
join it and ask any questions you may have.

To subscribe for announcements of releases, important changes and so
on, please follow [@ClojureWerkz](https://twitter.com/clojurewerkz) on
Twitter.


## Supported Clojure Versions

Mold requires Clojure 1.5+.


## Continuous Integration Status

[![Continuous Integration status](https://secure.travis-ci.org/clojurewerkz/mold.png)](http://travis-ci.org/clojurewerkz/mold)


## Mold Is a ClojureWerkz Project

mold is part of the [group of Clojure libraries known as ClojureWerkz](http://clojurewerkz.org), together with

 * [Langohr](http://clojurerabbitmq.info)
 * [Elastisch](http://clojureelasticsearch.info)
 * [Cassaforte](http://clojurecassandra.info)
 * [Monger](http://clojuremongodb.info)
 * [Titanium](http://titanium.clojurewerkz.org)
 * [Neocons](http://clojureneo4j.info)
 * [Meltdown](https://github.com/clojurewerkz/meltdown)

and several others.


## Development

mold uses [Leiningen
2](https://github.com/technomancy/leiningen/blob/master/doc/TUTORIAL.md). Make
sure you have it installed and then run tests against supported
Clojure versions using

    lein all test

Then create a branch and make your changes on it. Once you are done
with your changes and all tests pass, submit a pull request on GitHub.



## License

Copyright (C) 2014 Michael S. Klishin, Alex Petrov, and The ClojureWerkz Team.

Double licensed under the [Eclipse Public License](http://www.eclipse.org/legal/epl-v10.html) (the same as Clojure) or
the [Apache Public License 2.0](http://www.apache.org/licenses/LICENSE-2.0.html).
