(ns leiningen.new.clojurewerkz
  ""
  (:use leiningen.new.templates :only [->files qualified-name-to-path sanitize]))

(def ^{:const true}
  project-version "1.0.0-SNAPSHOT")
(def ^{:const true}
  clojure-version "1.3.0")

(def render (renderer "clojurewerkz"))


;; main template entry point
(defn clojurewerkz
  [^String proj-name]
  (let [data {:name            proj-name
              :project-version project-version
              :clojure-version clojure-version
              :fs-path         (qualified-name-to-path proj-name)
              :sanitized-ns    (sanitize-ns proj-name)}]
    (->files data
             ["README.md"                                (render "README.md" data)]
             ["src/clojure/clojurewerkz/{{fs-path}}.clj" (render "core.clj" data)])))
