(defproject clojurewerkz/eventoverse "0.2.0-alpha2"
  :description "A yet another events/logs collector"
  :url "http://github.com/clojurewerkz/eventoverse"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :dependencies [[org.clojure/clojure        "1.4.0-beta7"]
                 [org.clojure/tools.logging  "0.2.3" :exclude [org.clojure/clojure]]
                 [org.clojure/tools.cli      "0.2.1" :exclude [org.clojure/clojure]]
                 [org.clojure/data.json      "0.1.2" :exclude [org.clojure/clojure]]
                 [org.slf4j/slf4j-simple     "1.6.2"]
                 [org.slf4j/slf4j-api        "1.6.2"]
                 [clojurewerkz/support       "0.1.0-beta2"]
                 [com.orceo/orcette          "0.2.0"]
                 [com.novemberain/validateur "1.0.0"]
                 [com.novemberain/langohr    "1.0.0-beta1"]
                 [clojurewerkz/quartzite     "1.0.0-beta3"]
                 ;; what to use for persistence is largely an open question.
                 ;; mongodb's flexible schema & secondary indexes make it a decent choice for now. MK.
                 [com.novemberain/monger     "1.0.0-beta4"]
                 ;; our fork with updated dependencies
                 ;; published to clojars because the canonical one is not published
                 ;; anywhere at all. MK.
                 [com.novemberain/quartz-mongodb "1.0.0"]]
  :profiles {:1.3 {:dependencies [[org.clojure/clojure "1.3.0"]]}}
  :aliases  { "all" ["with-profile" "dev:dev,1.3"] }
  :warn-on-reflection false
  :aot                [clojurewerkz.eventoverse.collector.server]
  :javac-options      { :source "1.6" :target "1.6" }
  :run-aliases        {:collector clojurewerkz.eventoverse.collector.server}
  :source-paths       ["src/clojure"]
  :java-source-paths  ["src/java"]
  :resource-paths     ["src/resources"]
  :test-selectors   {:default        (complement :time-consuming)
                     :focus          :focus
                     :unit           :unit
                     :integration    :integration
                     :time-consuming :time-consuming
                     :all            (constantly true)})
