(ns clojurewerkz.eventoverse.collector.store
  (:refer-clojure :exclude [count])
  (:require [monger.collection :as c])
  (:import java.util.Date))


;;
;; API
;;

(defn events-bucket-name-for
  [^String app ^String env]
  (str app "_" env "_events"))

(defn errors-bucket-name-for
  [^String app ^String env]
  (str app "_" env "_invalid_events"))

(defn purge!
  [^String app ^String env]
  (c/remove (events-bucket-name-for app env) {}))

(defn count
  ([^String app ^String env]
     (c/count (events-bucket-name-for app env) {}))
  ([^String app ^String env conditions]
     (c/count (events-bucket-name-for app env) conditions)))

(defn any?
  ([^String app ^String env]
     (> (count app env) 0))
  ([^String app ^String env conditions]
     (> (count app env conditions) 0)))

(defn insert
  [^String coll m]
  (c/insert coll m))

(defn insert-event
  [^String app ^String env m]
  (c/insert (events-bucket-name-for app env) m))

(defn insert-batch
  [^String coll xs]
  (c/insert-batch coll xs))

(defn insert-events
  [^String app ^String env xs]
  (c/insert-batch (events-bucket-name-for app env) xs))
