(ns clojurewerkz.eventoverse.client.amqp
  (:require [langohr.core      :as lhc]
            [langohr.basic     :as lhb]
            [clojure.data.json :as json]
            [clojurewerkz.eventoverse.collector.amqp :as amqp])
  (:use monger.joda-time
        [clj-time.core :only [now]])
  (:import [com.rabbitmq.client Connection Channel]
           java.util.Date))

;;
;; Implementation
;;

(def ^Connection connection)
(def ^Channel    channel)
(def defaults)
(def ^{:const true} exchange "")

;; events exchange is a fanout so routing key is not used.
(def ^{:const true} routing-key "")

;;
;; API
;;

(defn initialize
  ([params]
     (initialize params {}))
  ([params default-attributes]
     (alter-var-root (var defaults)   (constantly default-attributes))
     (alter-var-root (var connection) (constantly (lhc/connect params)))
     (alter-var-root (var channel)    (constantly (lhc/create-channel connection)))))


(defn publish-event
  [event-type {et :type :as m}]
  (lhb/publish channel amqp/events-exchange-name routing-key (json/json-str (merge defaults (dissoc m :type) {:emitted_at (now)}))
               :type et))
