(ns clojurewerkz.eventoverse.collector.web.home
  (:require [noir.core :refer [defpage url-for]]
            [noir.response :refer [redirect]]
            [clojurewerkz.eventoverse.collector.web.common :refer [in-layout]]
            [clojurewerkz.eventoverse.collector.web.events :as events]
            [stencil.core :as st]
            [clojurewerkz.eventoverse.collector.store :as store]
            [clojure.string :as cs]))

;;
;; Implementation
;;

(def ^{:const true}
  env-separator-pattern #"_")

(def ^{:const true}
  env-separator "_")

(defn wrap-in-name
  [^String s]
  {:name s})

(defn inject-path
  [m]
  (let [parts (cs/split (:name m) env-separator-pattern)
        init  (butlast parts)
        app   (cs/join env-separator init)
        env   (last parts)
        path  (url-for events/recent-events {:app app :env env})]
    (assoc m :path path)))

(defn inject-most-recent-event-at
  [m]
  (assoc m :most_recent_event_at (:received_at (store/most-recent-event-in (:name m)))))

;;
;; API
;;

(defpage "/"
  []
  (redirect "/apps/"))


(defpage "/apps/"
  []
  (let [apps (->> (store/all-app-names)
                  (map wrap-in-name)
                  (map inject-path)
                  (map inject-most-recent-event-at)
                  (sort-by :most_recent_event_at)
                  (reverse))]
    (println apps)
    (in-layout
     (st/render-file "templates/apps/list" {:apps apps}))))
