(ns clojurewerkz.eventoverse.collector.store.generic-store)

(defprotocol GenericStore
  (setup! [store options])
  (purge! [store app env])
  (insert [store app env map])

  ;;
  ;; Tags
  ;;
  (get-count-for-tag [store app env tag])
  (first-page-tagged [store app env tag])
  (next-page-tagged [store app env tag])

  ;;
  ;; All events
  ;;

  (get-count [store app env])
  (first-range [store app env limit])
  (next-range-for [store app env range-end])
  (previous-range-for [store app env range-start])
  (most-recent-from [store app env]))