(ns clojurewerkz.eventoverse.collector.web.events
  (:require [noir.core :refer [defpage url-for]]
            [noir.response :as r]
            [stencil.core :as st]
            [clojurewerkz.eventoverse.collector.web.common :refer [in-layout
                                                                   format-list
                                                                   tags-from
                                                                   include-js
                                                                   custom-rows]]
            [clojurewerkz.eventoverse.collector.store :as store]))


;;
;; Implementation
;;


;;
;; API
;;

(defpage recent-events [:get "/apps/:app/env/:env/events/recent/"]
  {:keys [^String app ^String env]}
  (let [events (format-list (store/all-recent-events (store/events-bucket-name-for app env)) app env)
        event-rows  (custom-rows events "events/event_row")]
    (in-layout
     (st/render-file "templates/events/recent" {:event-rows event-rows
                                                :n (count events)
                                                :application app
                                                :environment env})
     {:javascripts (include-js "events/recent")})))

(defpage tagged-events [:get "/apps/:app/env/:env/events/tagged/:tagline"]
  {:keys [^String app ^String env ^String tagline]}
  (let [tags   (tags-from tagline)
        events (format-list (store/all-tagged-events (store/events-bucket-name-for app env) tags) app env)]
    (in-layout
     (st/render-file "templates/events/tagged" {:events events
                                                :n (count events)
                                                :tags tags
                                                :tagline tagline
                                                :application app
                                                :environment env
                                                :app-path (url-for recent-events {:app app :env env})}))))


(defpage hostname-events [:get "/apps/:app/env/:env/events/on-host/:hostname"]
  {:keys [^String app ^String env ^String hostname]}
  (let [events (format-list (store/all-events-on-host (store/events-bucket-name-for app env) hostname) app env)]
    (in-layout
     (st/render-file "templates/events/on_hostname" {:events events
                                                     :n (count events)
                                                     :hostname hostname
                                                     :application app
                                                     :environment env
                                                     :app-path (url-for recent-events {:app app :env env})}))))

(defpage event-search [:get "/apps/:app/env/:env/search/"]
  {:keys [^String app ^String env] :as params}
  (let [q      (:q params)
        events (format-list (store/all-events-by-search (store/events-bucket-name-for app env) q) app env)
        event-rows  (custom-rows events "events/event_row")]
    (in-layout
     (st/render-file "templates/events/search" {:event-rows event-rows
                                                :n (count events)
                                                :q q
                                                :application app
                                                :environment env
                                                :app-path (url-for recent-events {:app app :env env})}))))